/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.dto.trade;

import com.xeiam.xchange.dto.Order;
import java.math.BigDecimal;
import java.util.Date;
import org.joda.money.BigMoney;

public final class LimitOrder
extends Order
implements Comparable<LimitOrder> {
    private final BigMoney limitPrice;

    public LimitOrder(Order.OrderType type, BigDecimal tradableAmount, String tradableIdentifier, String transactionCurrency, String id, Date timestamp, BigMoney limitPrice) {
        super(type, tradableAmount, tradableIdentifier, transactionCurrency, id, timestamp);
        this.limitPrice = limitPrice;
    }

    public LimitOrder(Order.OrderType type, BigDecimal tradableAmount, String tradableIdentifier, String transactionCurrency, String id, BigMoney limitPrice) {
        super(type, tradableAmount, tradableIdentifier, transactionCurrency, id, null);
        this.limitPrice = limitPrice;
    }

    public LimitOrder(Order.OrderType type, BigDecimal tradableAmount, String tradableIdentifier, String transactionCurrency, BigMoney limitPrice, Date timestamp) {
        super(type, tradableAmount, tradableIdentifier, transactionCurrency, "", timestamp);
        this.limitPrice = limitPrice;
    }

    public LimitOrder(Order.OrderType type, BigDecimal tradableAmount, String tradableIdentifier, String transactionCurrency, BigMoney limitPrice) {
        super(type, tradableAmount, tradableIdentifier, transactionCurrency, "", null);
        this.limitPrice = limitPrice;
    }

    public BigMoney getLimitPrice() {
        return this.limitPrice;
    }

    @Override
    public String toString() {
        return "LimitOrder [limitPrice=" + this.limitPrice + ", " + super.toString() + "]";
    }

    @Override
    public int compareTo(LimitOrder limitOrder) {
        return this.getLimitPrice().getAmount().compareTo(limitOrder.getLimitPrice().getAmount()) * (this.getType() == Order.OrderType.BID ? -1 : 1);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.limitPrice != null ? this.limitPrice.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LimitOrder other = (LimitOrder)obj;
        if (!(this.limitPrice == other.limitPrice || this.limitPrice != null && this.limitPrice.equals((Object)other.limitPrice))) {
            return false;
        }
        return super.equals(obj);
    }
}

