/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.dto.trade;

import java.math.BigDecimal;
import org.joda.money.BigMoney;
import org.joda.money.CurrencyUnit;

public final class Wallet {
    private final String currency;
    private final BigMoney balance;

    public Wallet(String currency, BigMoney balance) {
        this.currency = currency;
        this.balance = balance;
    }

    public static Wallet createInstance(String currency, BigDecimal amount) {
        return new Wallet(currency, BigMoney.of((CurrencyUnit)CurrencyUnit.of((String)currency), (BigDecimal)amount));
    }

    public String getCurrency() {
        return this.currency;
    }

    public BigMoney getBalance() {
        return this.balance;
    }

    public String toString() {
        return "Wallet [currency=" + this.currency + ", balance=" + this.balance + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.balance == null ? 0 : this.balance.hashCode());
        result = 31 * result + (this.currency == null ? 0 : this.currency.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Wallet other = (Wallet)obj;
        if (this.balance == null ? other.balance != null : !this.balance.equals((Object)other.balance)) {
            return false;
        }
        return !(this.currency == null ? other.currency != null : !this.currency.equals(other.currency));
    }
}

