/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.service.streaming;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.service.streaming.BaseExchangeService;
import com.xeiam.xchange.service.streaming.ExchangeEvent;
import com.xeiam.xchange.service.streaming.ExchangeEventListener;
import com.xeiam.xchange.service.streaming.ExchangeStreamingConfiguration;
import com.xeiam.xchange.service.streaming.ReconnectService;
import com.xeiam.xchange.service.streaming.StreamingExchangeService;
import com.xeiam.xchange.service.streaming.WebSocketEventProducer;
import com.xeiam.xchange.utils.Assert;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWebSocketExchangeService
extends BaseExchangeService
implements StreamingExchangeService {
    private final Logger log = LoggerFactory.getLogger(BaseWebSocketExchangeService.class);
    protected final BlockingQueue<ExchangeEvent> consumerEventQueue = new LinkedBlockingQueue<ExchangeEvent>(1024);
    protected ReconnectService reconnectService;
    private WebSocketEventProducer exchangeEventProducer;

    public BaseWebSocketExchangeService(ExchangeSpecification exchangeSpecification, ExchangeStreamingConfiguration exchangeStreamingConfiguration) {
        super(exchangeSpecification);
        this.reconnectService = new ReconnectService(this, exchangeStreamingConfiguration);
    }

    protected synchronized void internalConnect(URI uri, ExchangeEventListener exchangeEventListener, Map<String, String> headers) {
        this.log.debug("internalConnect");
        Assert.notNull(exchangeEventListener, "runnableExchangeEventListener cannot be null");
        try {
            this.log.debug("Attempting to open a websocket against {}", (Object)uri);
            this.exchangeEventProducer = new WebSocketEventProducer(uri.toString(), exchangeEventListener, headers);
            this.exchangeEventProducer.connect();
        }
        catch (URISyntaxException e) {
            throw new ExchangeException("Failed to open websocket!", e);
        }
    }

    @Override
    public synchronized void disconnect() {
        if (this.exchangeEventProducer != null) {
            this.exchangeEventProducer.close();
        }
        this.log.debug("disconnect() called");
    }

    @Override
    public ExchangeEvent getNextEvent() throws InterruptedException {
        ExchangeEvent event = this.consumerEventQueue.take();
        if (this.reconnectService != null) {
            this.reconnectService.intercept(event);
        }
        return event;
    }

    @Override
    public void send(String msg) {
        this.exchangeEventProducer.send(msg);
    }
}

