/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.service.streaming;

import com.xeiam.xchange.service.streaming.ExchangeEvent;
import com.xeiam.xchange.service.streaming.ExchangeEventType;
import com.xeiam.xchange.service.streaming.ExchangeStreamingConfiguration;
import com.xeiam.xchange.service.streaming.StreamingExchangeService;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnectService {
    private final Logger log = LoggerFactory.getLogger(ReconnectService.class);
    private final ExchangeStreamingConfiguration exchangeStreamingConfiguration;
    private final StreamingExchangeService streamingExchangeService;
    private int numConnectionAttempts = 0;
    Timer timer = new Timer();
    TimerTask reconnectTask = new ReconnectTask();

    public ReconnectService(StreamingExchangeService streamingExchangeService, ExchangeStreamingConfiguration exchangeStreamingConfiguration) {
        this.streamingExchangeService = streamingExchangeService;
        this.exchangeStreamingConfiguration = exchangeStreamingConfiguration;
    }

    public void intercept(ExchangeEvent exchangeEvent) {
        this.reconnectTask.cancel();
        this.reconnectTask = new ReconnectTask();
        this.timer.schedule(this.reconnectTask, this.exchangeStreamingConfiguration.getTimeoutInMs());
        if (exchangeEvent.getEventType() == ExchangeEventType.ERROR || exchangeEvent.getEventType() == ExchangeEventType.DISCONNECT) {
            try {
                Thread.sleep(this.exchangeStreamingConfiguration.getReconnectWaitTimeInMs());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.reconnect();
        } else if (exchangeEvent.getEventType() == ExchangeEventType.CONNECT) {
            this.numConnectionAttempts = 0;
        }
    }

    private void reconnect() {
        this.log.debug("ExchangeType Error. Attempting reconnect " + this.numConnectionAttempts + " of " + this.exchangeStreamingConfiguration.getMaxReconnectAttempts());
        if (this.numConnectionAttempts >= this.exchangeStreamingConfiguration.getMaxReconnectAttempts()) {
            this.log.debug("Terminating reconnection attempts.");
            this.streamingExchangeService.disconnect();
            Thread.currentThread().interrupt();
            return;
        }
        this.streamingExchangeService.disconnect();
        this.streamingExchangeService.connect();
        ++this.numConnectionAttempts;
    }

    class ReconnectTask
    extends TimerTask {
        ReconnectTask() {
        }

        @Override
        public void run() {
            ReconnectService.this.log.debug("Time out!");
            ReconnectService.this.timer.purge();
            ReconnectService.this.reconnect();
        }
    }
}

