/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.utils.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;

public abstract class BooleanDeserializer
extends JsonDeserializer<Boolean> {
    private String trueValue;
    private String falseValue;

    protected BooleanDeserializer(String trueValue, String falseValue) {
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    public Boolean deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String valueAsString = jp.getValueAsString();
        if (this.trueValue.equals(valueAsString)) {
            return true;
        }
        if (this.falseValue.equals(valueAsString)) {
            return false;
        }
        throw new InvalidFormatException(String.format("Unrecognized value; expected %s or %s: %s", this.trueValue, this.falseValue, valueAsString), (Object)valueAsString, Boolean.class);
    }
}

