/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.campbx;

import com.xeiam.xchange.campbx.dto.marketdata.CampBXOrderBook;
import com.xeiam.xchange.campbx.dto.marketdata.CampBXTicker;
import com.xeiam.xchange.currency.MoneyUtils;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.trade.LimitOrder;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.joda.money.BigMoney;
import org.joda.money.CurrencyUnit;

public final class CampBXAdapters {
    public static OrderBook adaptOrders(CampBXOrderBook orderBook, String currency, String tradableIdentifier) {
        List<LimitOrder> asks = CampBXAdapters.createOrders(tradableIdentifier, currency, Order.OrderType.ASK, orderBook.getAsks());
        List<LimitOrder> bids = CampBXAdapters.createOrders(tradableIdentifier, currency, Order.OrderType.BID, orderBook.getBids());
        return new OrderBook(null, asks, bids);
    }

    private static List<LimitOrder> createOrders(String tradableIdentifier, String currency, Order.OrderType orderType, List<List<BigDecimal>> orders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (List<BigDecimal> ask : orders) {
            CampBXAdapters.checkArgument(ask.size() == 2, "Expected a pair (price, amount) but got {0} elements.", ask.size());
            limitOrders.add(CampBXAdapters.createOrder(tradableIdentifier, currency, ask, orderType));
        }
        return limitOrders;
    }

    private static LimitOrder createOrder(String tradableIdentifier, String currency, List<BigDecimal> priceAndAmount, Order.OrderType orderType) {
        return new LimitOrder(orderType, priceAndAmount.get(1), tradableIdentifier, currency, BigMoney.of((CurrencyUnit)CurrencyUnit.USD, (BigDecimal)priceAndAmount.get(0)));
    }

    private static void checkArgument(boolean argument, String msgPattern, Object ... msgArgs) {
        if (!argument) {
            throw new IllegalArgumentException(MessageFormat.format(msgPattern, msgArgs));
        }
    }

    public static Ticker adaptTicker(CampBXTicker campbxTicker, String currency, String tradableIdentifier) {
        BigMoney last = MoneyUtils.parse((String)(currency + " " + campbxTicker.getLast()));
        BigMoney bid = MoneyUtils.parse((String)(currency + " " + campbxTicker.getBid()));
        BigMoney ask = MoneyUtils.parse((String)(currency + " " + campbxTicker.getAsk()));
        return Ticker.TickerBuilder.newInstance().withTradableIdentifier(tradableIdentifier).withLast(last).withBid(bid).withAsk(ask).build();
    }
}

