/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.campbx.service.polling;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.campbx.CampBX;
import com.xeiam.xchange.campbx.dto.CampBXResponse;
import com.xeiam.xchange.campbx.dto.account.MyFunds;
import com.xeiam.xchange.dto.account.AccountInfo;
import com.xeiam.xchange.dto.trade.Wallet;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingAccountService;
import java.math.BigDecimal;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.RestProxyFactory;

public class CampBXPollingAccountService
extends BasePollingExchangeService
implements PollingAccountService {
    private final Logger logger = LoggerFactory.getLogger(CampBXPollingAccountService.class);
    private final CampBX campBX;

    public CampBXPollingAccountService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        this.campBX = (CampBX)RestProxyFactory.createProxy(CampBX.class, (String)exchangeSpecification.getSslUri());
    }

    public AccountInfo getAccountInfo() {
        MyFunds myFunds = this.campBX.getMyFunds(this.exchangeSpecification.getUserName(), this.exchangeSpecification.getPassword());
        this.logger.debug("myFunds = {}", (Object)myFunds);
        if (!myFunds.isError()) {
            return new AccountInfo(this.exchangeSpecification.getUserName(), Arrays.asList(Wallet.createInstance((String)"BTC", (BigDecimal)myFunds.getTotalBTC()), Wallet.createInstance((String)"USD", (BigDecimal)myFunds.getTotalUSD())));
        }
        throw new ExchangeException("Error calling getAccountInfo(): " + myFunds.getError());
    }

    public String withdrawFunds(BigDecimal amount, String address) {
        CampBXResponse campBXResponse = this.campBX.withdrawBtc(this.exchangeSpecification.getUserName(), this.exchangeSpecification.getPassword(), address, amount);
        this.logger.debug("campBXResponse = {}", (Object)campBXResponse);
        if (!campBXResponse.isError()) {
            return campBXResponse.getSuccess();
        }
        throw new ExchangeException("Error calling withdrawFunds(): " + campBXResponse.getError());
    }

    public String requestBitcoinDepositAddress(String ... arguments) {
        CampBXResponse campBXResponse = this.campBX.getDepositAddress(this.exchangeSpecification.getUserName(), this.exchangeSpecification.getPassword());
        this.logger.debug("campBXResponse = {}", (Object)campBXResponse);
        if (!campBXResponse.isError()) {
            return campBXResponse.getSuccess();
        }
        throw new ExchangeException("Error calling requestBitcoinDepositAddress(): " + campBXResponse.getError());
    }
}

