/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitstamp;

import com.xeiam.xchange.bitstamp.BitstampUtils;
import com.xeiam.xchange.bitstamp.dto.account.BitstampBalance;
import com.xeiam.xchange.bitstamp.dto.marketdata.BitstampOrderBook;
import com.xeiam.xchange.bitstamp.dto.marketdata.BitstampTicker;
import com.xeiam.xchange.bitstamp.dto.marketdata.BitstampTransaction;
import com.xeiam.xchange.bitstamp.dto.trade.BitstampUserTransaction;
import com.xeiam.xchange.currency.MoneyUtils;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.account.AccountInfo;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trade;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.dto.trade.Wallet;
import com.xeiam.xchange.utils.DateUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.joda.money.BigMoney;
import org.joda.money.CurrencyUnit;

public final class BitstampAdapters {
    private BitstampAdapters() {
    }

    public static AccountInfo adaptAccountInfo(BitstampBalance bitstampBalance, String userName) {
        Wallet usdWallet = Wallet.createInstance((String)"USD", (BigDecimal)bitstampBalance.getUsdBalance());
        Wallet btcWallet = Wallet.createInstance((String)"BTC", (BigDecimal)bitstampBalance.getBtcBalance());
        return new AccountInfo(userName, Arrays.asList(usdWallet, btcWallet));
    }

    public static OrderBook adaptOrders(BitstampOrderBook bitstampOrderBook, String tradableIdentifier, String currency) {
        List<LimitOrder> asks = BitstampAdapters.createOrders(tradableIdentifier, currency, Order.OrderType.ASK, bitstampOrderBook.getAsks());
        List<LimitOrder> bids = BitstampAdapters.createOrders(tradableIdentifier, currency, Order.OrderType.BID, bitstampOrderBook.getBids());
        Date date = new Date(bitstampOrderBook.getTimestamp() * 1000L);
        return new OrderBook(date, asks, bids);
    }

    private static List<LimitOrder> createOrders(String tradableIdentifier, String currency, Order.OrderType orderType, List<List<BigDecimal>> orders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (List<BigDecimal> ask : orders) {
            BitstampAdapters.checkArgument(ask.size() == 2, "Expected a pair (price, amount) but got {0} elements.", ask.size());
            limitOrders.add(BitstampAdapters.createOrder(tradableIdentifier, currency, ask, orderType));
        }
        return limitOrders;
    }

    private static LimitOrder createOrder(String tradableIdentifier, String currency, List<BigDecimal> priceAndAmount, Order.OrderType orderType) {
        return new LimitOrder(orderType, priceAndAmount.get(1), tradableIdentifier, currency, BigMoney.of((CurrencyUnit)CurrencyUnit.USD, (BigDecimal)priceAndAmount.get(0)));
    }

    private static void checkArgument(boolean argument, String msgPattern, Object ... msgArgs) {
        if (!argument) {
            throw new IllegalArgumentException(MessageFormat.format(msgPattern, msgArgs));
        }
    }

    public static Trades adaptTrades(BitstampTransaction[] transactions, String tradableIdentifier, String currency) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        for (BitstampTransaction tx : transactions) {
            trades.add(new Trade(null, tx.getAmount(), tradableIdentifier, currency, BigMoney.of((CurrencyUnit)CurrencyUnit.of((String)currency), (BigDecimal)tx.getPrice()), DateUtils.fromMillisUtc((long)(tx.getDate() * 1000L)), (long)tx.getTid()));
        }
        return new Trades(trades);
    }

    public static Ticker adaptTicker(BitstampTicker bitstampTicker, String tradableIdentifier, String currency) {
        BigMoney last = MoneyUtils.parse((String)(currency + " " + bitstampTicker.getLast()));
        BigMoney bid = MoneyUtils.parse((String)(currency + " " + bitstampTicker.getBid()));
        BigMoney ask = MoneyUtils.parse((String)(currency + " " + bitstampTicker.getAsk()));
        BigMoney high = MoneyUtils.parse((String)(currency + " " + bitstampTicker.getHigh()));
        BigMoney low = MoneyUtils.parse((String)(currency + " " + bitstampTicker.getLow()));
        BigDecimal volume = bitstampTicker.getVolume();
        return Ticker.TickerBuilder.newInstance().withTradableIdentifier(tradableIdentifier).withLast(last).withBid(bid).withAsk(ask).withHigh(high).withLow(low).withVolume(volume).build();
    }

    public static Trades adaptTradeHistory(BitstampUserTransaction[] bitstampUserTransactions) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        for (int i = 0; i < bitstampUserTransactions.length; ++i) {
            BitstampUserTransaction bitstampUserTransaction = bitstampUserTransactions[i];
            if (!bitstampUserTransaction.getType().equals((Object)BitstampUserTransaction.TransactionType.trade)) continue;
            Order.OrderType orderType = bitstampUserTransaction.getUsd().doubleValue() > 0.0 ? Order.OrderType.ASK : Order.OrderType.BID;
            BigDecimal tradableAmount = bitstampUserTransaction.getBtc();
            String tradableIdentifier = "BTC";
            String transactionCurrency = "USD";
            BigMoney price = MoneyUtils.parse((String)(transactionCurrency + " " + bitstampUserTransaction.getPrice()));
            Date timestamp = BitstampUtils.parseDate(bitstampUserTransaction.getDatetime());
            long id = bitstampUserTransaction.getId();
            Trade trade = new Trade(orderType, tradableAmount, tradableIdentifier, transactionCurrency, price, timestamp, id);
            trades.add(trade);
        }
        return new Trades(trades);
    }
}

