/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitstamp.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;

public final class BitstampTransaction {
    private final long date;
    private final int tid;
    private final BigDecimal price;
    private final BigDecimal amount;

    public BitstampTransaction(@JsonProperty(value="date") long date, @JsonProperty(value="tid") int tid, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="amount") BigDecimal amount) {
        this.date = date;
        this.tid = tid;
        this.price = price;
        this.amount = amount;
    }

    public int getTid() {
        return this.tid;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public long getDate() {
        return this.date;
    }

    public BigDecimal calculateFeeBtc() {
        return this.roundUp(this.amount.multiply(new BigDecimal(0.5))).divide(new BigDecimal(100.0));
    }

    private BigDecimal roundUp(BigDecimal x) {
        long n = x.longValue();
        return new BigDecimal(x.equals(new BigDecimal(n)) ? n : n + 1L);
    }

    public BigDecimal calculateFeeUsd() {
        return this.calculateFeeBtc().multiply(this.price);
    }

    public String toString() {
        return "Transaction [date=" + this.date + ", tid=" + this.tid + ", price=" + this.price + ", amount=" + this.amount + "]";
    }
}

