/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitstamp.dto.trade;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xeiam.xchange.bitstamp.BitstampUtils;
import java.math.BigDecimal;
import java.util.Date;

public final class BitstampOrder {
    private final int id;
    private final String datetime;
    private final int type;
    private final BigDecimal price;
    private final BigDecimal amount;

    public BitstampOrder(@JsonProperty(value="id") int id, @JsonProperty(value="datetime") String datetime, @JsonProperty(value="type") int type, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="amount") BigDecimal amount) {
        this.id = id;
        this.datetime = datetime;
        this.type = type;
        this.price = price;
        this.amount = amount;
    }

    public String getDatetime() {
        return this.datetime;
    }

    public int getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    @JsonIgnore
    public Date getTime() {
        return BitstampUtils.parseDate(this.getDatetime());
    }

    public String toString() {
        return String.format("Order{id=%s, datetime=%s, type=%s, price=%s, amount=%s}", this.id, this.datetime, this.type, this.price, this.amount);
    }
}

