/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitstamp.service.polling;

import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotAvailableFromExchangeException;
import com.xeiam.xchange.bitstamp.BitstampAdapters;
import com.xeiam.xchange.bitstamp.BitstampAuthenticated;
import com.xeiam.xchange.bitstamp.BitstampUtils;
import com.xeiam.xchange.bitstamp.dto.trade.BitstampOrder;
import com.xeiam.xchange.bitstamp.dto.trade.BitstampUserTransaction;
import com.xeiam.xchange.bitstamp.service.BitstampDigest;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.dto.trade.MarketOrder;
import com.xeiam.xchange.dto.trade.OpenOrders;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingTradeService;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.joda.money.BigMoney;
import org.joda.money.CurrencyUnit;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;

public class BitstampPollingTradeService
extends BasePollingExchangeService
implements PollingTradeService {
    private BitstampAuthenticated bitstampAuthenticated;
    private ParamsDigest signatureCreator;

    public BitstampPollingTradeService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        this.bitstampAuthenticated = (BitstampAuthenticated)RestProxyFactory.createProxy(BitstampAuthenticated.class, (String)exchangeSpecification.getSslUri());
        this.signatureCreator = BitstampDigest.createInstance(exchangeSpecification.getSecretKey(), exchangeSpecification.getUserName(), exchangeSpecification.getApiKey());
    }

    public OpenOrders getOpenOrders() {
        BitstampOrder[] openOrders = this.bitstampAuthenticated.getOpenOrders(this.exchangeSpecification.getApiKey(), this.signatureCreator, BitstampUtils.getNonce());
        ArrayList<LimitOrder> orders = new ArrayList<LimitOrder>();
        for (BitstampOrder bitstampOrder : openOrders) {
            orders.add(new LimitOrder(bitstampOrder.getType() == 0 ? Order.OrderType.BID : Order.OrderType.ASK, bitstampOrder.getAmount(), "BTC", "USD", Integer.toString(bitstampOrder.getId()), BigMoney.of((CurrencyUnit)CurrencyUnit.USD, (BigDecimal)bitstampOrder.getPrice())));
        }
        return new OpenOrders(orders);
    }

    public String placeMarketOrder(MarketOrder marketOrder) {
        throw new NotAvailableFromExchangeException();
    }

    public String placeLimitOrder(LimitOrder limitOrder) {
        BitstampOrder bitstampOrder = limitOrder.getType() == Order.OrderType.BID ? this.bitstampAuthenticated.buy(this.exchangeSpecification.getApiKey(), this.signatureCreator, BitstampUtils.getNonce(), limitOrder.getTradableAmount(), limitOrder.getLimitPrice().getAmount()) : this.bitstampAuthenticated.sell(this.exchangeSpecification.getApiKey(), this.signatureCreator, BitstampUtils.getNonce(), limitOrder.getTradableAmount(), limitOrder.getLimitPrice().getAmount());
        return Integer.toString(bitstampOrder.getId());
    }

    public boolean cancelOrder(String orderId) {
        return this.bitstampAuthenticated.cancelOrder(this.exchangeSpecification.getApiKey(), this.signatureCreator, BitstampUtils.getNonce(), Integer.parseInt(orderId)).equals(true);
    }

    public Trades getTradeHistory(Object ... arguments) {
        Long numberOfTransactions = Long.MAX_VALUE;
        try {
            numberOfTransactions = (Long)arguments[0];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        BitstampUserTransaction[] bitstampUserTransactions = this.bitstampAuthenticated.getUserTransactions(this.exchangeSpecification.getApiKey(), this.signatureCreator, BitstampUtils.getNonce(), numberOfTransactions);
        return BitstampAdapters.adaptTradeHistory(bitstampUserTransactions);
    }
}

