/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.RestProxyFactory;

class Config {
    public static final String RESCU_PROPERTIES = "rescu.properties";
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final String HTTP_READ_TIMEOUT = "rescu.http.readTimeoutMillis";
    private static final String PROXY_HOST = "rescu.http.readProxyHost";
    private static final String PROXY_PORT = "rescu.http.readProxyPort";
    private static final int httpReadTimeout;
    private static final String proxyHost;
    private static final Integer proxyPort;

    Config() {
    }

    public static int getHttpReadTimeout() {
        return httpReadTimeout;
    }

    public static String getProxyHost() {
        return proxyHost;
    }

    public static Integer getProxyPort() {
        return proxyPort;
    }

    static {
        Properties dfts = new Properties();
        dfts.setProperty(HTTP_READ_TIMEOUT, "30000");
        Properties properties = new Properties(dfts);
        InputStream propsStream = RestProxyFactory.class.getResourceAsStream("/rescu.properties");
        if (propsStream != null) {
            try {
                properties.load(propsStream);
                log.debug("Loaded properties from {}.", (Object)RESCU_PROPERTIES);
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading rescu.properties", e);
            }
        }
        httpReadTimeout = Integer.parseInt(properties.getProperty(HTTP_READ_TIMEOUT));
        proxyHost = properties.getProperty(PROXY_HOST);
        String proxyPortStr = properties.getProperty(PROXY_PORT);
        proxyPort = proxyPortStr == null ? null : Integer.valueOf(Integer.parseInt(proxyPortStr));
        log.debug("Configuration from rescu.properties:");
        log.debug("httpReadTimeout = {}", (Object)httpReadTimeout);
        log.debug("proxyHost = {}", (Object)proxyHost);
        log.debug("proxyPort = {}", (Object)proxyPort);
    }
}

