/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import si.mazi.rescu.AnnotationUtils;
import si.mazi.rescu.Params;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestMethodMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestInvocation
implements Serializable {
    protected static final List<Class<? extends Annotation>> PARAM_ANNOTATION_CLASSES = Arrays.asList(QueryParam.class, PathParam.class, FormParam.class, HeaderParam.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<Class<? extends Annotation>, Params> paramsMap;
    private final List<Object> unannanotatedParams = new ArrayList<Object>();
    private String contentType;
    private String methodPath;
    private String invocationUrl;
    private String queryString;
    private String path;
    private RestMethodMetadata restMethodMetadata;

    RestInvocation(RestMethodMetadata restMethodMetadata, Object[] args) {
        this.restMethodMetadata = restMethodMetadata;
        this.paramsMap = new HashMap<Class<? extends Annotation>, Params>();
        for (Class<? extends Annotation> annotationClass : PARAM_ANNOTATION_CLASSES) {
            this.paramsMap.put(annotationClass, Params.of());
        }
        Annotation[][] paramAnnotations = restMethodMetadata.parameterAnnotations;
        for (int i = 0; i < paramAnnotations.length; ++i) {
            Annotation[] paramAnns = paramAnnotations[i];
            if (paramAnns.length == 0) {
                this.unannanotatedParams.add(args[i]);
            }
            for (Annotation paramAnn : paramAnns) {
                String paramName = RestInvocation.getParamName(paramAnn);
                if (paramName == null) continue;
                this.paramsMap.get(paramAnn.annotationType()).add(paramName, args[i]);
            }
        }
        Map<Class<? extends Annotation>, Annotation> methodAnnotationMap = restMethodMetadata.methodAnnotationMap;
        for (Class<? extends Annotation> paramAnnotationClass : methodAnnotationMap.keySet()) {
            Annotation annotation = methodAnnotationMap.get(paramAnnotationClass);
            if (annotation == null) continue;
            String paramName = RestInvocation.getParamName(annotation);
            this.paramsMap.get(paramAnnotationClass).add(paramName, restMethodMetadata.methodName);
        }
        this.contentType = restMethodMetadata.contentType;
        this.methodPath = this.getPath(restMethodMetadata.methodPathTemplate);
        this.path = restMethodMetadata.intfacePath;
        this.path = RestInvocation.appendIfNotEmpty(this.path, this.methodPath, "/");
        this.queryString = this.paramsMap.get(QueryParam.class).asQueryString();
        this.invocationUrl = RestInvocation.getInvocationUrl(restMethodMetadata.baseUrl, this.path, this.queryString);
        for (int i = 0; i < this.unannanotatedParams.size(); ++i) {
            Object param = this.unannanotatedParams.get(i);
            if (!(param instanceof ParamsDigest)) continue;
            this.unannanotatedParams.set(i, ((ParamsDigest)param).digestParams(this));
        }
        for (Params params : this.paramsMap.values()) {
            params.digestAll(this);
        }
    }

    public RestInvocation(Map<Class<? extends Annotation>, Params> paramsMap, String contentType) {
        this.contentType = contentType;
        this.paramsMap = new LinkedHashMap<Class<? extends Annotation>, Params>(paramsMap);
    }

    private static String getParamName(Annotation queryParam) {
        for (Class<? extends Annotation> annotationClass : PARAM_ANNOTATION_CLASSES) {
            String paramName = AnnotationUtils.getValueOrNull(annotationClass, queryParam);
            if (paramName == null) continue;
            return paramName;
        }
        return null;
    }

    static String getInvocationUrl(String baseUrl, String path, String queryString) {
        String completeUrl = baseUrl;
        completeUrl = RestInvocation.appendIfNotEmpty(completeUrl, path, "/");
        completeUrl = RestInvocation.appendIfNotEmpty(completeUrl, queryString, "?");
        return completeUrl;
    }

    static String appendIfNotEmpty(String url, String next, String separator) {
        if (url.length() > 0 && next != null && next.length() > 0) {
            if (!url.endsWith(separator) && !next.startsWith(separator)) {
                url = url + separator;
            }
            url = url + next;
        }
        return url;
    }

    public String getPath(String methodPath) {
        return this.paramsMap.get(PathParam.class).applyToPath(methodPath);
    }

    public String getRequestBody() {
        if ("application/x-www-form-urlencoded".equals(this.contentType)) {
            return this.paramsMap.get(FormParam.class).asFormEncodedRequestBody();
        }
        if ("application/json".equals(this.contentType)) {
            if (!this.paramsMap.get(FormParam.class).isEmpty()) {
                throw new IllegalArgumentException("@FormParams are not allowed with application/json");
            }
            if (this.unannanotatedParams.size() > 1) {
                throw new IllegalArgumentException("Can only have a single unnanotated parameter with application/json");
            }
            if (this.unannanotatedParams.size() == 0) {
                return null;
            }
            try {
                return this.objectMapper.writeValueAsString(this.unannanotatedParams.get(0));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Error writing json, probably a bug in rescu.", e);
            }
        }
        throw new IllegalArgumentException("Unsupported media type: " + this.contentType);
    }

    public Map<String, String> getHttpHeaders() {
        return this.paramsMap.get(HeaderParam.class).asHttpHeaders();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getInvocationUrl() {
        return this.invocationUrl;
    }

    public String getMethodPath() {
        return this.methodPath;
    }

    public String getPath() {
        return this.path;
    }

    public String getBaseUrl() {
        return this.restMethodMetadata.baseUrl;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public RestMethodMetadata getRestMethodMetadata() {
        return this.restMethodMetadata;
    }

    public Object getParamValue(Class<? extends Annotation> paramAnnotation, String paramName) {
        if (!PARAM_ANNOTATION_CLASSES.contains(paramAnnotation)) {
            throw new IllegalArgumentException("Unsupported annotation type: " + paramAnnotation + ". Should be one of " + PARAM_ANNOTATION_CLASSES);
        }
        return this.paramsMap.get(paramAnnotation).getParamValue(paramName);
    }
}

