/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.currency;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.joda.money.BigMoney;
import org.joda.money.CurrencyUnit;

public class MoneyUtils {
    private MoneyUtils() {
    }

    public static BigMoney parse(String value) {
        try {
            return BigMoney.parse((String)value);
        }
        catch (IllegalArgumentException e) {
            BigDecimal bigDecimal = new BigDecimal(value.substring(4));
            return BigMoney.parse((String)(value.substring(0, 3) + " " + bigDecimal.toPlainString()));
        }
    }

    public static BigMoney parseMoney(String currency, BigDecimal amount) {
        return amount == null ? null : BigMoney.of((CurrencyUnit)CurrencyUnit.of((String)currency), (BigDecimal)amount);
    }

    public static BigMoney parseMoney(String currency, double amount) {
        return BigMoney.of((CurrencyUnit)CurrencyUnit.of((String)currency), (double)amount);
    }

    public static BigMoney parseBitcoin(String value) {
        BigMoney unscaled = BigMoney.parse((String)value);
        if (!unscaled.getCurrencyUnit().getCode().equals("BTC")) {
            throw new IllegalArgumentException("Must have BTC currency code");
        }
        return unscaled.withScale(12);
    }

    public static BigMoney fromSatoshi(long value) {
        BigMoney unscaled = BigMoney.ofScale((CurrencyUnit)CurrencyUnit.getInstance((String)"BTC"), (long)value, (int)8);
        if (!unscaled.getCurrencyUnit().getCode().equals("BTC")) {
            throw new IllegalArgumentException("Must have BTC currency code");
        }
        return unscaled.withScale(12);
    }

    public static String formatBitcoin(BigMoney value) {
        if (!value.getCurrencyUnit().getCode().equals("BTC")) {
            throw new IllegalArgumentException("Must have BTC currency code");
        }
        return value.withScale(8, RoundingMode.HALF_UP).toString();
    }
}

