/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.dto.marketdata;

import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.marketdata.OrderBookUpdate;
import com.xeiam.xchange.dto.trade.LimitOrder;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.joda.money.BigMoney;
import org.joda.money.BigMoneyProvider;

public final class OrderBook {
    private Date timeStamp;
    private final List<LimitOrder> asks;
    private final List<LimitOrder> bids;

    public OrderBook(Date timeStamp, List<LimitOrder> asks, List<LimitOrder> bids) {
        this.timeStamp = timeStamp;
        this.asks = asks;
        this.bids = bids;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public List<LimitOrder> getAsks() {
        Collections.sort(this.asks);
        return this.asks;
    }

    public List<LimitOrder> getBids() {
        Collections.sort(this.bids);
        return this.bids;
    }

    public void update(LimitOrder limitOrder) {
        if (limitOrder.getType().equals((Object)Order.OrderType.ASK)) {
            Iterator<LimitOrder> it = this.asks.iterator();
            while (it.hasNext()) {
                LimitOrder order = it.next();
                if (order.getLimitPrice().compareTo((BigMoneyProvider)limitOrder.getLimitPrice()) != 0) continue;
                it.remove();
                break;
            }
            this.asks.add(limitOrder);
            Collections.sort(this.asks);
        } else {
            Iterator<LimitOrder> it = this.bids.iterator();
            while (it.hasNext()) {
                LimitOrder order = it.next();
                if (order.getLimitPrice().compareTo((BigMoneyProvider)limitOrder.getLimitPrice()) != 0) continue;
                it.remove();
                break;
            }
            this.bids.add(limitOrder);
            Collections.sort(this.bids);
        }
        this.updateDate(limitOrder.getTimestamp());
    }

    public void update(OrderBookUpdate orderBookUpdate) {
        Iterator<LimitOrder> it = orderBookUpdate.getLimitOrder().getType() == Order.OrderType.ASK ? this.asks.iterator() : this.bids.iterator();
        while (it.hasNext()) {
            LimitOrder order = it.next();
            if (order.getLimitPrice().compareTo((BigMoneyProvider)orderBookUpdate.getLimitOrder().getLimitPrice()) != 0) continue;
            it.remove();
            break;
        }
        if (orderBookUpdate.getTotalVolume().compareTo(BigDecimal.ZERO) != 0) {
            Order.OrderType type = orderBookUpdate.getLimitOrder().getType();
            BigDecimal tradeableAmount = orderBookUpdate.getTotalVolume();
            String tradeableIdentifier = orderBookUpdate.getLimitOrder().getTradableIdentifier();
            String transitionCurrency = orderBookUpdate.getLimitOrder().getTransactionCurrency();
            String id = orderBookUpdate.getLimitOrder().getId();
            Date date = orderBookUpdate.getLimitOrder().getTimestamp();
            BigMoney limit = orderBookUpdate.getLimitOrder().getLimitPrice();
            LimitOrder updatedOrder = new LimitOrder(type, tradeableAmount, tradeableIdentifier, transitionCurrency, id, date, limit);
            if (orderBookUpdate.getLimitOrder().getType() == Order.OrderType.ASK) {
                this.asks.add(updatedOrder);
                Collections.sort(this.asks);
            } else {
                this.bids.add(updatedOrder);
                Collections.sort(this.bids);
            }
        }
        this.updateDate(orderBookUpdate.getLimitOrder().getTimestamp());
    }

    private void updateDate(Date updateDate) {
        if (updateDate != null && (this.timeStamp == null || updateDate.after(this.timeStamp))) {
            this.timeStamp = updateDate;
        }
    }

    public String toString() {
        return "Depth [timestamp: " + this.timeStamp + ", asks=" + this.asks.toString() + ", bids=" + this.bids.toString() + "]";
    }
}

