/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.campbx.service.polling;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotAvailableFromExchangeException;
import com.xeiam.xchange.campbx.CampBX;
import com.xeiam.xchange.campbx.CampBXAdapters;
import com.xeiam.xchange.campbx.CampBXUtils;
import com.xeiam.xchange.campbx.dto.marketdata.CampBXOrderBook;
import com.xeiam.xchange.campbx.dto.marketdata.CampBXTicker;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import com.xeiam.xchange.utils.Assert;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.RestProxyFactory;

public class CampBXPollingMarketDataService
extends BasePollingExchangeService
implements PollingMarketDataService {
    private final Logger logger = LoggerFactory.getLogger(CampBXPollingMarketDataService.class);
    private final CampBX campBX;

    public CampBXPollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        this.campBX = (CampBX)RestProxyFactory.createProxy(CampBX.class, (String)exchangeSpecification.getSslUri());
    }

    public Ticker getTicker(String tradableIdentifier, String currency) throws IOException {
        this.verify(tradableIdentifier, currency);
        CampBXTicker campbxTicker = this.campBX.getTicker();
        this.logger.debug("campbxTicker = {}", (Object)campbxTicker);
        if (!campbxTicker.isError()) {
            return CampBXAdapters.adaptTicker(campbxTicker, currency, tradableIdentifier);
        }
        throw new ExchangeException("Error calling getTicker(): " + campbxTicker.getError());
    }

    public OrderBook getPartialOrderBook(String tradableIdentifier, String currency) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public OrderBook getFullOrderBook(String tradableIdentifier, String currency) throws IOException {
        CampBXOrderBook campBXOrderBook = this.campBX.getOrderBook();
        this.logger.debug("campBXOrderBook = {}", (Object)campBXOrderBook);
        if (!campBXOrderBook.isError()) {
            return CampBXAdapters.adaptOrders(campBXOrderBook, currency, tradableIdentifier);
        }
        throw new ExchangeException("Error calling getFullOrderBook(): " + campBXOrderBook.getError());
    }

    public Trades getTrades(String tradableIdentifier, String currency, Object ... args) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    private void verify(String tradableIdentifier, String currency) {
        Assert.notNull((Object)tradableIdentifier, (String)"tradableIdentifier cannot be null");
        Assert.notNull((Object)currency, (String)"currency cannot be null");
        Assert.isTrue((boolean)CampBXUtils.isValidCurrencyPair(new CurrencyPair(tradableIdentifier, currency)), (String)("currencyPair is not valid:" + tradableIdentifier + " " + currency));
    }

    public List<CurrencyPair> getExchangeSymbols() {
        return CampBXUtils.CURRENCY_PAIRS;
    }
}

