/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.campbx.service.polling;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotYetImplementedForExchangeException;
import com.xeiam.xchange.campbx.CampBX;
import com.xeiam.xchange.campbx.dto.CampBXOrder;
import com.xeiam.xchange.campbx.dto.CampBXResponse;
import com.xeiam.xchange.campbx.dto.trade.MyOpenOrders;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.dto.trade.MarketOrder;
import com.xeiam.xchange.dto.trade.OpenOrders;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingTradeService;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import org.joda.money.BigMoney;
import org.joda.money.CurrencyUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.RestProxyFactory;

public class CampBXPollingTradeService
extends BasePollingExchangeService
implements PollingTradeService {
    private final Logger logger = LoggerFactory.getLogger(CampBXPollingTradeService.class);
    private static final MessageFormat ID_FORMAT = new MessageFormat("{0}-{1}");
    private final CampBX campbx;

    public CampBXPollingTradeService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        this.campbx = (CampBX)RestProxyFactory.createProxy(CampBX.class, (String)exchangeSpecification.getSslUri());
    }

    public OpenOrders getOpenOrders() throws IOException {
        MyOpenOrders myOpenOrders = this.campbx.getOpenOrders(this.exchangeSpecification.getUserName(), this.exchangeSpecification.getPassword());
        this.logger.debug("myOpenOrders = {}", (Object)myOpenOrders);
        if (!myOpenOrders.isError()) {
            BigMoney price;
            String id;
            ArrayList<LimitOrder> orders = new ArrayList<LimitOrder>();
            for (CampBXOrder cbo : myOpenOrders.getBuy()) {
                if (cbo.isError() || cbo.isInfo()) {
                    this.logger.debug("Skipping non-order in Buy: " + cbo);
                    continue;
                }
                id = CampBXPollingTradeService.composeOrderId(CampBX.OrderType.Buy, cbo.getOrderID());
                price = BigMoney.of((CurrencyUnit)CurrencyUnit.USD, (BigDecimal)cbo.getPrice());
                orders.add(new LimitOrder(Order.OrderType.BID, cbo.getQuantity(), "BTC", "USD", id, cbo.getOrderEntered(), price));
            }
            for (CampBXOrder cbo : myOpenOrders.getSell()) {
                if (cbo.isError() || cbo.isInfo()) {
                    this.logger.debug("Skipping non-order in Sell: " + cbo);
                    continue;
                }
                id = CampBXPollingTradeService.composeOrderId(CampBX.OrderType.Buy, cbo.getOrderID());
                price = BigMoney.of((CurrencyUnit)CurrencyUnit.USD, (BigDecimal)cbo.getPrice());
                orders.add(new LimitOrder(Order.OrderType.ASK, cbo.getQuantity(), "BTC", "USD", id, cbo.getOrderEntered(), price));
            }
            return new OpenOrders(orders);
        }
        throw new ExchangeException("Error calling getOpenOrders(): " + myOpenOrders.getError());
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        CampBX.AdvTradeMode mode = marketOrder.getType() == Order.OrderType.ASK ? CampBX.AdvTradeMode.AdvancedSell : CampBX.AdvTradeMode.AdvancedBuy;
        CampBXResponse campBXResponse = this.campbx.tradeAdvancedMarketEnter(this.exchangeSpecification.getUserName(), this.exchangeSpecification.getPassword(), mode, marketOrder.getTradableAmount(), CampBX.MarketPrice.Market, null, null, null);
        this.logger.debug("campBXResponse = {}", (Object)campBXResponse);
        if (!campBXResponse.isError()) {
            return CampBXPollingTradeService.composeOrderId(campBXResponse.getSuccess(), marketOrder.getType());
        }
        throw new ExchangeException("Error calling placeMarketOrder(): " + campBXResponse.getError());
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        CampBX.TradeMode mode = limitOrder.getType() == Order.OrderType.ASK ? CampBX.TradeMode.QuickSell : CampBX.TradeMode.QuickBuy;
        CampBXResponse campBXResponse = this.campbx.tradeEnter(this.exchangeSpecification.getUserName(), this.exchangeSpecification.getPassword(), mode, limitOrder.getTradableAmount(), limitOrder.getLimitPrice().getAmount());
        this.logger.debug("campBXResponse = {}", (Object)campBXResponse);
        if (!campBXResponse.isError()) {
            return CampBXPollingTradeService.composeOrderId(campBXResponse.getSuccess(), limitOrder.getType());
        }
        throw new ExchangeException("Error calling placeLimitOrder(): " + campBXResponse.getError());
    }

    public boolean cancelOrder(String orderId) throws IOException {
        ParsedId parsedId = CampBXPollingTradeService.parseOrderId(orderId);
        CampBXResponse campBXResponse = this.campbx.tradeCancel(this.exchangeSpecification.getUserName(), this.exchangeSpecification.getPassword(), parsedId.type, Long.parseLong(parsedId.id));
        this.logger.debug("campBXResponse = {}", (Object)campBXResponse);
        if (!campBXResponse.isError()) {
            return campBXResponse.isSuccess();
        }
        throw new ExchangeException("Error calling cancelOrder(): " + campBXResponse.getError());
    }

    static String composeOrderId(String id, Order.OrderType orderType) {
        CampBX.OrderType type = orderType == Order.OrderType.ASK ? CampBX.OrderType.Sell : CampBX.OrderType.Buy;
        return CampBXPollingTradeService.composeOrderId(type, id);
    }

    static String composeOrderId(CampBX.OrderType type, String id) {
        return ID_FORMAT.format(new Object[]{type, id});
    }

    static ParsedId parseOrderId(String compositeId) {
        try {
            Object[] parts = ID_FORMAT.parse(compositeId);
            return new ParsedId(CampBX.OrderType.valueOf(parts[0].toString()), parts[1].toString());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Can't parse order id: " + compositeId);
        }
    }

    public Trades getTradeHistory(Object ... arguments) {
        throw new NotYetImplementedForExchangeException();
    }

    static class ParsedId {
        final CampBX.OrderType type;
        final String id;

        private ParsedId(CampBX.OrderType type, String id) {
            this.type = type;
            this.id = id;
        }
    }
}

