/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.mtgox;

import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.currency.MoneyUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import org.joda.money.BigMoney;

public final class MtGoxUtils {
    public static final List<CurrencyPair> CURRENCY_PAIRS = Arrays.asList(CurrencyPair.BTC_USD, CurrencyPair.BTC_EUR, CurrencyPair.BTC_GBP, CurrencyPair.BTC_AUD, CurrencyPair.BTC_CAD, CurrencyPair.BTC_CHF, CurrencyPair.BTC_JPY, CurrencyPair.BTC_CNY, CurrencyPair.BTC_DKK, CurrencyPair.BTC_HKD, CurrencyPair.BTC_NZD, CurrencyPair.BTC_PLN, CurrencyPair.BTC_RUB, CurrencyPair.BTC_SEK, CurrencyPair.BTC_SGD, CurrencyPair.BTC_THB, CurrencyPair.BTC_NOK);
    public static final int REFRESH_RATE = 10;
    public static final int BTC_VOLUME_AND_AMOUNT_INT_2_DECIMAL_FACTOR = 100000000;
    public static final int PRICE_INT_2_DECIMAL_FACTOR = 100000;
    public static final int JPY_SEK_PRICE_INT_2_DECIMAL_FACTOR = 1000;

    private MtGoxUtils() {
    }

    public static String getAmountString(BigDecimal amount) {
        return amount.multiply(new BigDecimal(100000000)).toPlainString();
    }

    public static String getPriceString(BigMoney price) {
        if (!price.getCurrencyUnit().toString().equals("JPY") && !price.getCurrencyUnit().toString().equals("SEK")) {
            return price.getAmount().multiply(new BigDecimal(100000)).stripTrailingZeros().toPlainString();
        }
        return price.getAmount().multiply(new BigDecimal(1000)).stripTrailingZeros().toPlainString();
    }

    public static BigMoney getPrice(String currency, long price) {
        if (!currency.equals("JPY") && !currency.equals("SEK")) {
            return MoneyUtils.parse((String)(currency + " " + new BigDecimal(price).divide(new BigDecimal(100000))));
        }
        return MoneyUtils.parse((String)(currency + " " + new BigDecimal(price).divide(new BigDecimal(1000))));
    }

    public static boolean isValidCurrencyPair(CurrencyPair currencyPair) {
        return CURRENCY_PAIRS.contains(currencyPair);
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Problem encoding, probably bug in code.", e);
        }
    }

    public static long getNonce() {
        return System.currentTimeMillis();
    }
}

