/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.mtgox.v0;

import com.xeiam.xchange.currency.MoneyUtils;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trade;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.mtgox.MtGoxUtils;
import com.xeiam.xchange.mtgox.v0.dto.marketdata.MtGoxTicker;
import com.xeiam.xchange.mtgox.v0.dto.marketdata.MtGoxTrades;
import com.xeiam.xchange.utils.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.joda.money.BigMoney;

@Deprecated
public final class MtGoxAdapters {
    private MtGoxAdapters() {
    }

    public static LimitOrder adaptOrder(BigDecimal amount, BigDecimal price, String currency, String orderTypeString, String id) {
        Order.OrderType orderType = orderTypeString.equalsIgnoreCase("bid") ? Order.OrderType.BID : Order.OrderType.ASK;
        String tradableIdentifier = "BTC";
        BigMoney limitPrice = MoneyUtils.parse((String)(currency + " " + price));
        return new LimitOrder(orderType, amount, tradableIdentifier, currency, id, null, limitPrice);
    }

    public static List<LimitOrder> adaptOrders(List<BigDecimal[]> mtgoxOrders, String currency, String orderType, String id) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        if (mtgoxOrders == null) {
            return limitOrders;
        }
        for (BigDecimal[] mtgoxOrder : mtgoxOrders) {
            limitOrders.add(MtGoxAdapters.adaptOrder(mtgoxOrder[1], mtgoxOrder[0], currency, orderType, id));
        }
        return limitOrders;
    }

    public static Trade adaptTrade(MtGoxTrades mtGoxTrade) {
        Order.OrderType orderType = mtGoxTrade.getTrade_type().equals("bid") ? Order.OrderType.BID : Order.OrderType.ASK;
        BigDecimal amount = new BigDecimal(mtGoxTrade.getAmount_int()).divide(new BigDecimal(100000000));
        String tradableIdentifier = mtGoxTrade.getItem();
        String transactionCurrency = mtGoxTrade.getPrice_currency();
        BigMoney price = MtGoxUtils.getPrice(transactionCurrency, mtGoxTrade.getPrice_int());
        Date dateTime = DateUtils.fromMillisUtc((long)(mtGoxTrade.getDate() * 1000L));
        return new Trade(orderType, amount, tradableIdentifier, transactionCurrency, price, dateTime, mtGoxTrade.getTid());
    }

    public static Trades adaptTrades(MtGoxTrades[] mtGoxTrades) {
        ArrayList<Trade> tradesList = new ArrayList<Trade>();
        if (mtGoxTrades == null) {
            return new Trades(tradesList);
        }
        for (MtGoxTrades mtGoxTrade : mtGoxTrades) {
            tradesList.add(MtGoxAdapters.adaptTrade(mtGoxTrade));
        }
        return new Trades(tradesList);
    }

    public static Ticker adaptTicker(MtGoxTicker mtGoxTicker, String tradeableIdentifier, String currency) {
        BigMoney last = MoneyUtils.parse((String)(currency + " " + mtGoxTicker.getTicker().getLast()));
        BigMoney bid = MoneyUtils.parse((String)(currency + " " + mtGoxTicker.getTicker().getBuy()));
        BigMoney ask = MoneyUtils.parse((String)(currency + " " + mtGoxTicker.getTicker().getSell()));
        BigMoney high = MoneyUtils.parse((String)(currency + " " + mtGoxTicker.getTicker().getHigh()));
        BigMoney low = MoneyUtils.parse((String)(currency + " " + mtGoxTicker.getTicker().getLow()));
        BigDecimal volume = mtGoxTicker.getTicker().getVol();
        return Ticker.TickerBuilder.newInstance().withTradableIdentifier(tradeableIdentifier).withLast(last).withBid(bid).withAsk(ask).withHigh(high).withLow(low).withVolume(volume).build();
    }
}

