/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.mtgox.v0.service.marketdata.polling;

import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotYetImplementedForExchangeException;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.mtgox.MtGoxUtils;
import com.xeiam.xchange.mtgox.v0.MtGoxAdapters;
import com.xeiam.xchange.mtgox.v0.MtGoxV0;
import com.xeiam.xchange.mtgox.v0.dto.marketdata.MtGoxDepth;
import com.xeiam.xchange.mtgox.v0.dto.marketdata.MtGoxTicker;
import com.xeiam.xchange.mtgox.v0.dto.marketdata.MtGoxTrades;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import com.xeiam.xchange.utils.Assert;
import java.util.List;
import si.mazi.rescu.RestProxyFactory;

@Deprecated
public class MtGoxPollingMarketDataService
extends BasePollingExchangeService
implements PollingMarketDataService {
    private final MtGoxV0 mtGoxV0;

    public MtGoxPollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        this.mtGoxV0 = (MtGoxV0)RestProxyFactory.createProxy(MtGoxV0.class, (String)exchangeSpecification.getSslUri());
    }

    public Ticker getTicker(String tradableIdentifier, String currency) {
        this.verify(tradableIdentifier, currency);
        MtGoxTicker mtGoxTicker = this.mtGoxV0.getTicker(currency);
        return MtGoxAdapters.adaptTicker(mtGoxTicker, tradableIdentifier, currency);
    }

    public OrderBook getPartialOrderBook(String tradableIdentifier, String currency) {
        throw new NotYetImplementedForExchangeException();
    }

    public OrderBook getFullOrderBook(String tradableIdentifier, String currency) {
        this.verify(tradableIdentifier, currency);
        MtGoxDepth mtgoxFullDepth = this.mtGoxV0.getFullDepth(currency);
        List<LimitOrder> asks = MtGoxAdapters.adaptOrders(mtgoxFullDepth.getAsks(), currency, "ask", "");
        List<LimitOrder> bids = MtGoxAdapters.adaptOrders(mtgoxFullDepth.getBids(), currency, "bid", "");
        return new OrderBook(null, asks, bids);
    }

    public Trades getTrades(String tradableIdentifier, String currency, Object ... args) {
        this.verify(tradableIdentifier, currency);
        MtGoxTrades[] mtGoxTrades = this.mtGoxV0.getTrades(currency);
        return MtGoxAdapters.adaptTrades(mtGoxTrades);
    }

    private void verify(String tradableIdentifier, String currency) {
        Assert.notNull((Object)tradableIdentifier, (String)"tradableIdentifier cannot be null");
        Assert.notNull((Object)currency, (String)"currency cannot be null");
        Assert.isTrue((boolean)MtGoxUtils.isValidCurrencyPair(new CurrencyPair(tradableIdentifier, currency)), (String)("currencyPair is not valid:" + tradableIdentifier + " " + currency));
    }

    public List<CurrencyPair> getExchangeSymbols() {
        return MtGoxUtils.CURRENCY_PAIRS;
    }
}

