/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.mtgox.v2;

import com.xeiam.xchange.BaseExchange;
import com.xeiam.xchange.Exchange;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.mtgox.v2.service.polling.MtGoxPollingAccountService;
import com.xeiam.xchange.mtgox.v2.service.polling.MtGoxPollingMarketDataService;
import com.xeiam.xchange.mtgox.v2.service.polling.MtGoxPollingTradeService;
import com.xeiam.xchange.mtgox.v2.service.streaming.MtGoxStreamingConfiguration;
import com.xeiam.xchange.mtgox.v2.service.streaming.MtGoxWebsocketService;
import com.xeiam.xchange.service.streaming.ExchangeStreamingConfiguration;
import com.xeiam.xchange.service.streaming.StreamingExchangeService;

public class MtGoxExchange
extends BaseExchange
implements Exchange {
    public void applySpecification(ExchangeSpecification exchangeSpecification) {
        super.applySpecification(exchangeSpecification);
        this.pollingMarketDataService = new MtGoxPollingMarketDataService(exchangeSpecification);
        this.pollingTradeService = new MtGoxPollingTradeService(exchangeSpecification);
        this.pollingAccountService = new MtGoxPollingAccountService(exchangeSpecification);
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass().getCanonicalName());
        exchangeSpecification.setSslUri("https://data.mtgox.com");
        exchangeSpecification.setPlainTextUriStreaming("ws://websocket.mtgox.com");
        exchangeSpecification.setSslUriStreaming("wss://websocket.mtgox.com");
        exchangeSpecification.setPlainTextUri("http://data.mtgox.com");
        exchangeSpecification.setHost("mtgox.com");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("MtGox");
        exchangeSpecification.setExchangeDescription("MtGox is a Bitcoin exchange registered in Japan.");
        return exchangeSpecification;
    }

    public StreamingExchangeService getStreamingExchangeService(ExchangeStreamingConfiguration configuration) {
        if (configuration instanceof MtGoxStreamingConfiguration) {
            return new MtGoxWebsocketService(this.getExchangeSpecification(), (MtGoxStreamingConfiguration)configuration);
        }
        throw new IllegalArgumentException("MtGox only supports the MtGoxV2StreamingConfiguration");
    }
}

