/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.mtgox.v2.service.streaming;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.dto.marketdata.OrderBookUpdate;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trade;
import com.xeiam.xchange.mtgox.v2.MtGoxAdapters;
import com.xeiam.xchange.mtgox.v2.dto.account.polling.MtGoxAccountInfo;
import com.xeiam.xchange.mtgox.v2.dto.account.streaming.MtGoxWalletUpdate;
import com.xeiam.xchange.mtgox.v2.dto.marketdata.MtGoxDepthUpdate;
import com.xeiam.xchange.mtgox.v2.dto.marketdata.MtGoxTicker;
import com.xeiam.xchange.mtgox.v2.dto.marketdata.MtGoxTrade;
import com.xeiam.xchange.mtgox.v2.dto.trade.polling.MtGoxOpenOrder;
import com.xeiam.xchange.mtgox.v2.dto.trade.streaming.MtGoxOrderCanceled;
import com.xeiam.xchange.mtgox.v2.dto.trade.streaming.MtGoxTradeLag;
import com.xeiam.xchange.service.streaming.DefaultExchangeEvent;
import com.xeiam.xchange.service.streaming.ExchangeEvent;
import com.xeiam.xchange.service.streaming.ExchangeEventListener;
import com.xeiam.xchange.service.streaming.ExchangeEventType;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtGoxExchangeEventListener
extends ExchangeEventListener {
    private static final Logger log = LoggerFactory.getLogger(MtGoxExchangeEventListener.class);
    private final ObjectMapper streamObjectMapper;
    private final BlockingQueue<ExchangeEvent> consumerEventQueue;

    public MtGoxExchangeEventListener(BlockingQueue<ExchangeEvent> consumerEventQueue) {
        this.consumerEventQueue = consumerEventQueue;
        this.streamObjectMapper = new ObjectMapper();
        this.streamObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void handleEvent(ExchangeEvent exchangeEvent) {
        switch (exchangeEvent.getEventType()) {
            case CONNECT: {
                log.debug("MtGox connected");
                this.addToEventQueue(exchangeEvent);
                break;
            }
            case DISCONNECT: {
                log.debug("MtGox disconnected");
                this.addToEventQueue(exchangeEvent);
                break;
            }
            case MESSAGE: {
                try {
                    Map rawJSON = (Map)this.streamObjectMapper.readValue(exchangeEvent.getData(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                    String operation = (String)rawJSON.get("op");
                    if ("private".equals(operation)) {
                        String priv = (String)rawJSON.get("private");
                        if ("user_order".equals(priv)) {
                            MtGoxOpenOrder order = (MtGoxOpenOrder)this.streamObjectMapper.readValue(this.streamObjectMapper.writeValueAsString(rawJSON.get("user_order")), MtGoxOpenOrder.class);
                            DefaultExchangeEvent userOrderEvent = new DefaultExchangeEvent(ExchangeEventType.USER_ORDER, exchangeEvent.getData(), (Object)order);
                            this.addToEventQueue((ExchangeEvent)userOrderEvent);
                            break;
                        }
                        if ("lag".equals(priv)) {
                            MtGoxTradeLag lag = (MtGoxTradeLag)this.streamObjectMapper.readValue(this.streamObjectMapper.writeValueAsString(rawJSON.get("lag")), MtGoxTradeLag.class);
                            DefaultExchangeEvent lagEvent = new DefaultExchangeEvent(ExchangeEventType.TRADE_LAG, exchangeEvent.getData(), (Object)lag);
                            this.addToEventQueue((ExchangeEvent)lagEvent);
                            break;
                        }
                        if ("wallet".equals(priv)) {
                            MtGoxWalletUpdate walletUpdate = (MtGoxWalletUpdate)this.streamObjectMapper.readValue(this.streamObjectMapper.writeValueAsString(rawJSON.get("wallet")), MtGoxWalletUpdate.class);
                            DefaultExchangeEvent walletUpdateEvent = new DefaultExchangeEvent(ExchangeEventType.USER_WALLET_UPDATE, exchangeEvent.getData(), (Object)walletUpdate);
                            this.addToEventQueue((ExchangeEvent)walletUpdateEvent);
                            break;
                        }
                    } else if ("result".equals(operation)) {
                        String id = (String)rawJSON.get("id");
                        if ("idkey".equals(id)) {
                            DefaultExchangeEvent idEvent = new DefaultExchangeEvent(ExchangeEventType.PRIVATE_ID_KEY, null, rawJSON.get("result"));
                            this.addToEventQueue((ExchangeEvent)idEvent);
                            break;
                        }
                        if ("orders".equals(id)) {
                            MtGoxOpenOrder[] orders = null;
                            if (rawJSON.get("result") != null) {
                                orders = (MtGoxOpenOrder[])this.streamObjectMapper.readValue(this.streamObjectMapper.writeValueAsString(rawJSON.get("result")), MtGoxOpenOrder[].class);
                            }
                            DefaultExchangeEvent ordersEvent = new DefaultExchangeEvent(ExchangeEventType.USER_ORDERS_LIST, exchangeEvent.getData(), orders);
                            this.addToEventQueue((ExchangeEvent)ordersEvent);
                            break;
                        }
                        if ("info".equals(id)) {
                            MtGoxAccountInfo accountInfo = (MtGoxAccountInfo)this.streamObjectMapper.readValue(this.streamObjectMapper.writeValueAsString(rawJSON.get("result")), MtGoxAccountInfo.class);
                            DefaultExchangeEvent accountInfoEvent = new DefaultExchangeEvent(ExchangeEventType.ACCOUNT_INFO, exchangeEvent.getData(), (Object)accountInfo);
                            this.addToEventQueue((ExchangeEvent)accountInfoEvent);
                            break;
                        }
                        if (id.startsWith("order_add")) {
                            DefaultExchangeEvent userOrderAddedEvent = new DefaultExchangeEvent(ExchangeEventType.USER_ORDER_ADDED, exchangeEvent.getData(), rawJSON.get("result"));
                            this.addToEventQueue((ExchangeEvent)userOrderAddedEvent);
                            break;
                        }
                        if (id.startsWith("order_cancel")) {
                            MtGoxOrderCanceled orderCanceled = (MtGoxOrderCanceled)this.streamObjectMapper.readValue(this.streamObjectMapper.writeValueAsString(rawJSON.get("result")), MtGoxOrderCanceled.class);
                            DefaultExchangeEvent userOrderCanceledEvent = new DefaultExchangeEvent(ExchangeEventType.USER_ORDER_CANCELED, exchangeEvent.getData(), (Object)orderCanceled);
                            this.addToEventQueue((ExchangeEvent)userOrderCanceledEvent);
                            break;
                        }
                    } else if ("remark".equals(operation)) {
                        System.out.println("Msg from server: " + rawJSON.toString());
                        break;
                    }
                    if (rawJSON.containsKey("ticker")) {
                        MtGoxTicker mtGoxTicker = (MtGoxTicker)this.streamObjectMapper.readValue(this.streamObjectMapper.writeValueAsString(rawJSON.get("ticker")), MtGoxTicker.class);
                        Ticker ticker = MtGoxAdapters.adaptTicker(mtGoxTicker);
                        DefaultExchangeEvent tickerEvent = new DefaultExchangeEvent(ExchangeEventType.TICKER, exchangeEvent.getData(), (Object)ticker);
                        this.addToEventQueue((ExchangeEvent)tickerEvent);
                        break;
                    }
                    if (rawJSON.containsKey("trade")) {
                        MtGoxTrade mtGoxTradeStream = (MtGoxTrade)this.streamObjectMapper.readValue(this.streamObjectMapper.writeValueAsString(rawJSON.get("trade")), MtGoxTrade.class);
                        Trade trade = MtGoxAdapters.adaptTrade(mtGoxTradeStream);
                        DefaultExchangeEvent tradeEvent = new DefaultExchangeEvent(ExchangeEventType.TRADE, exchangeEvent.getData(), (Object)trade);
                        this.addToEventQueue((ExchangeEvent)tradeEvent);
                        break;
                    }
                    if (rawJSON.containsKey("depth")) {
                        MtGoxDepthUpdate mtGoxDepthStream = (MtGoxDepthUpdate)this.streamObjectMapper.readValue(this.streamObjectMapper.writeValueAsString(rawJSON.get("depth")), MtGoxDepthUpdate.class);
                        OrderBookUpdate orderBookUpdate = MtGoxAdapters.adaptDepthUpdate(mtGoxDepthStream);
                        DefaultExchangeEvent depthEvent = new DefaultExchangeEvent(ExchangeEventType.DEPTH, exchangeEvent.getData(), (Object)orderBookUpdate);
                        this.addToEventQueue((ExchangeEvent)depthEvent);
                        break;
                    }
                    log.debug("MtGox operational message");
                    System.out.println("msg: " + rawJSON.toString());
                    this.addToEventQueue(exchangeEvent);
                }
                catch (JsonParseException e) {
                    log.error("Error parsing returned JSON", (Throwable)e);
                }
                catch (JsonMappingException e) {
                    log.error("Error parsing returned JSON", (Throwable)e);
                }
                catch (IOException e) {
                    log.error("Error parsing returned JSON", (Throwable)e);
                }
                break;
            }
            case ERROR: {
                log.error("Error message: " + exchangeEvent.getPayload());
                this.addToEventQueue(exchangeEvent);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ExchangeEventType " + exchangeEvent.getEventType().name());
            }
        }
    }

    private void addToEventQueue(ExchangeEvent event) {
        try {
            this.consumerEventQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new ExchangeException("InterruptedException!", (Throwable)e);
        }
    }
}

