/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.btcchina;

import com.xeiam.xchange.btcchina.BTCChinaUtils;
import com.xeiam.xchange.btcchina.dto.BTCChinaResponse;
import com.xeiam.xchange.btcchina.dto.BTCChinaValue;
import com.xeiam.xchange.btcchina.dto.account.BTCChinaAccountInfo;
import com.xeiam.xchange.btcchina.dto.marketdata.BTCChinaTicker;
import com.xeiam.xchange.btcchina.dto.marketdata.BTCChinaTrade;
import com.xeiam.xchange.btcchina.dto.trade.BTCChinaOrder;
import com.xeiam.xchange.currency.MoneyUtils;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.account.AccountInfo;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trade;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.dto.trade.OpenOrders;
import com.xeiam.xchange.dto.trade.Wallet;
import com.xeiam.xchange.utils.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.joda.money.BigMoney;
import org.joda.money.CurrencyUnit;

public final class BTCChinaAdapters {
    private BTCChinaAdapters() {
    }

    public static List<LimitOrder> adaptOrders(List<BigDecimal[]> btcchinaOrders, String currency, Order.OrderType orderType) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (BigDecimal[] btcchinaOrder : btcchinaOrders) {
            limitOrders.add(BTCChinaAdapters.adaptOrder(btcchinaOrder[1], btcchinaOrder[0], currency, orderType));
        }
        return limitOrders;
    }

    public static LimitOrder adaptOrder(BigDecimal amount, BigDecimal price, String currency, Order.OrderType orderType) {
        String tradableIdentifier = "BTC";
        BigMoney limitPrice = MoneyUtils.parse((String)(currency + " " + price));
        return new LimitOrder(orderType, amount, tradableIdentifier, currency, "", null, limitPrice);
    }

    public static Trade adaptTrade(BTCChinaTrade btcChinaTrade, String currency, String tradableIdentifier) {
        BigDecimal amount = btcChinaTrade.getAmount();
        BigMoney price = MoneyUtils.parse((String)(currency + " " + btcChinaTrade.getPrice()));
        Date date = DateUtils.fromMillisUtc((long)(btcChinaTrade.getDate() * 1000L));
        return new Trade(null, amount, tradableIdentifier, currency, price, date, btcChinaTrade.getTid());
    }

    public static Trades adaptTrades(BTCChinaTrade[] btcchinaTrades, String currency, String tradableIdentifier) {
        ArrayList<Trade> tradesList = new ArrayList<Trade>();
        for (BTCChinaTrade btcchinaTrade : btcchinaTrades) {
            tradesList.add(BTCChinaAdapters.adaptTrade(btcchinaTrade, currency, tradableIdentifier));
        }
        return new Trades(tradesList);
    }

    public static String getPriceString(BigMoney price) {
        return price.getAmount().stripTrailingZeros().toPlainString();
    }

    public static Ticker adaptTicker(BTCChinaTicker btcChinaTicker, String currency, String tradableIdentifier) {
        BigMoney last = MoneyUtils.parse((String)(currency + " " + btcChinaTicker.getTicker().getLast()));
        BigMoney high = MoneyUtils.parse((String)(currency + " " + btcChinaTicker.getTicker().getHigh()));
        BigMoney low = MoneyUtils.parse((String)(currency + " " + btcChinaTicker.getTicker().getLow()));
        BigMoney buy = MoneyUtils.parse((String)(currency + " " + btcChinaTicker.getTicker().getBuy()));
        BigMoney sell = MoneyUtils.parse((String)(currency + " " + btcChinaTicker.getTicker().getSell()));
        BigDecimal volume = btcChinaTicker.getTicker().getVol();
        return Ticker.TickerBuilder.newInstance().withTradableIdentifier(tradableIdentifier).withLast(last).withHigh(high).withLow(low).withBid(buy).withAsk(sell).withVolume(volume).build();
    }

    public static AccountInfo adaptAccountInfo(BTCChinaResponse<BTCChinaAccountInfo> response) {
        BTCChinaAccountInfo result = response.getResult();
        return new AccountInfo(result.getProfile().getUsername(), BTCChinaAdapters.adaptWallets(result.getBalances(), result.getFrozens()));
    }

    public static List<Wallet> adaptWallets(Map<String, BTCChinaValue> balances, Map<String, BTCChinaValue> frozens) {
        ArrayList<Wallet> wallets = new ArrayList<Wallet>();
        for (Map.Entry<String, BTCChinaValue> entry : balances.entrySet()) {
            Wallet wallet;
            BTCChinaValue frozen = frozens.get(entry.getKey());
            if (frozen == null || (wallet = BTCChinaAdapters.adaptWallet(entry.getValue(), frozen)) == null) continue;
            wallets.add(wallet);
        }
        return wallets;
    }

    public static Wallet adaptWallet(BTCChinaValue balance, BTCChinaValue frozen) {
        if (balance != null && frozen != null) {
            BigDecimal balanceAmount = BTCChinaUtils.valueToBigDecimal(balance);
            BigDecimal frozenAmount = BTCChinaUtils.valueToBigDecimal(frozen);
            BigMoney cash = BigMoney.of((CurrencyUnit)CurrencyUnit.of((String)balance.getCurrency()), (BigDecimal)balanceAmount.add(frozenAmount));
            return new Wallet(balance.getCurrency(), cash);
        }
        return null;
    }

    public static OpenOrders adaptOpenOrders(List<BTCChinaOrder> orders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        if (orders != null) {
            for (BTCChinaOrder order : orders) {
                LimitOrder limitOrder;
                System.out.println(order);
                if (!order.getStatus().equals("open") || (limitOrder = BTCChinaAdapters.adaptLimitOrder(order)) == null) continue;
                limitOrders.add(limitOrder);
            }
        }
        return new OpenOrders(limitOrders);
    }

    public static LimitOrder adaptLimitOrder(BTCChinaOrder order) {
        Order.OrderType orderType = order.getType().equals("bid") ? Order.OrderType.BID : Order.OrderType.ASK;
        BigDecimal amount = order.getAmount();
        String id = Long.toString(order.getId());
        Date date = new Date(order.getDate() * 1000L);
        BigMoney price = BigMoney.of((CurrencyUnit)CurrencyUnit.of((String)order.getCurrency()), (BigDecimal)order.getPrice());
        return new LimitOrder(orderType, amount, "BTC", "CNY", id, date, price);
    }
}

