/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.btcchina.service.polling;

import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.btcchina.BTCChina;
import com.xeiam.xchange.btcchina.BTCChinaAdapters;
import com.xeiam.xchange.btcchina.BTCChinaUtils;
import com.xeiam.xchange.btcchina.dto.BTCChinaID;
import com.xeiam.xchange.btcchina.dto.account.BTCChinaAccountInfo;
import com.xeiam.xchange.btcchina.dto.account.request.BTCChinaGetAccountInfoRequest;
import com.xeiam.xchange.btcchina.dto.account.request.BTCChinaRequestWithdrawalRequest;
import com.xeiam.xchange.btcchina.dto.account.response.BTCChinaGetAccountInfoResponse;
import com.xeiam.xchange.btcchina.dto.account.response.BTCChinaRequestWithdrawalResponse;
import com.xeiam.xchange.btcchina.service.BTCChinaDigest;
import com.xeiam.xchange.dto.account.AccountInfo;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingAccountService;
import com.xeiam.xchange.utils.Assert;
import java.io.IOException;
import java.math.BigDecimal;
import org.joda.money.CurrencyUnit;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;

public class BTCChinaPollingAccountService
extends BasePollingExchangeService
implements PollingAccountService {
    private final BTCChina btcchina;
    private ParamsDigest signatureCreator;

    public BTCChinaPollingAccountService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        Assert.notNull((Object)exchangeSpecification.getSslUri(), (String)"Exchange specification URI cannot be null");
        this.btcchina = (BTCChina)RestProxyFactory.createProxy(BTCChina.class, (String)exchangeSpecification.getSslUri());
        this.signatureCreator = BTCChinaDigest.createInstance(exchangeSpecification.getApiKey(), exchangeSpecification.getSecretKey());
    }

    public AccountInfo getAccountInfo() throws IOException {
        BTCChinaGetAccountInfoResponse response = this.btcchina.getAccountInfo(this.signatureCreator, BTCChinaUtils.getNonce(), new BTCChinaGetAccountInfoRequest());
        return BTCChinaAdapters.adaptAccountInfo(response);
    }

    public String withdrawFunds(BigDecimal amount, String address) throws IOException {
        BTCChinaRequestWithdrawalResponse response = this.btcchina.requestWithdrawal(this.signatureCreator, BTCChinaUtils.getNonce(), new BTCChinaRequestWithdrawalRequest(CurrencyUnit.of((String)"BTC"), amount));
        return ((BTCChinaID)response.getResult()).getId();
    }

    public String requestBitcoinDepositAddress(String ... arguments) throws IOException {
        BTCChinaGetAccountInfoResponse response = this.btcchina.getAccountInfo(this.signatureCreator, BTCChinaUtils.getNonce(), new BTCChinaGetAccountInfoRequest());
        return ((BTCChinaAccountInfo)response.getResult()).getProfile().getBtcDepositAddress();
    }
}

