/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.btcchina.service.polling;

import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotAvailableFromExchangeException;
import com.xeiam.xchange.NotYetImplementedForExchangeException;
import com.xeiam.xchange.btcchina.BTCChina;
import com.xeiam.xchange.btcchina.BTCChinaAdapters;
import com.xeiam.xchange.btcchina.BTCChinaUtils;
import com.xeiam.xchange.btcchina.dto.BTCChinaResponse;
import com.xeiam.xchange.btcchina.dto.trade.BTCChinaOrders;
import com.xeiam.xchange.btcchina.dto.trade.request.BTCChinaBuyOrderRequest;
import com.xeiam.xchange.btcchina.dto.trade.request.BTCChinaCancelOrderRequest;
import com.xeiam.xchange.btcchina.dto.trade.request.BTCChinaGetOrdersRequest;
import com.xeiam.xchange.btcchina.dto.trade.request.BTCChinaSellOrderRequest;
import com.xeiam.xchange.btcchina.dto.trade.response.BTCChinaBooleanResponse;
import com.xeiam.xchange.btcchina.dto.trade.response.BTCChinaGetOrdersResponse;
import com.xeiam.xchange.btcchina.service.BTCChinaDigest;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.dto.trade.MarketOrder;
import com.xeiam.xchange.dto.trade.OpenOrders;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingTradeService;
import com.xeiam.xchange.utils.Assert;
import java.io.IOException;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;

public class BTCChinaPollingTradeService
extends BasePollingExchangeService
implements PollingTradeService {
    private final BTCChina btcchina;
    private ParamsDigest signatureCreator;

    public BTCChinaPollingTradeService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        Assert.notNull((Object)exchangeSpecification.getSslUri(), (String)"Exchange specification URI cannot be null");
        this.btcchina = (BTCChina)RestProxyFactory.createProxy(BTCChina.class, (String)exchangeSpecification.getSslUri());
        this.signatureCreator = BTCChinaDigest.createInstance(exchangeSpecification.getApiKey(), exchangeSpecification.getSecretKey());
    }

    public OpenOrders getOpenOrders() throws IOException {
        BTCChinaGetOrdersResponse response = this.btcchina.getOrders(this.signatureCreator, BTCChinaUtils.getNonce(), new BTCChinaGetOrdersRequest());
        return BTCChinaAdapters.adaptOpenOrders(((BTCChinaOrders)response.getResult()).getOrders());
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        String orderId = null;
        if (limitOrder.getTradableIdentifier() == "BTC" && limitOrder.getTransactionCurrency() == "CNY") {
            long nonce = BTCChinaUtils.getNonce();
            BTCChinaResponse response = null;
            if (limitOrder.getType() == Order.OrderType.BID) {
                response = this.btcchina.buyOrder(this.signatureCreator, nonce, new BTCChinaBuyOrderRequest(limitOrder.getLimitPrice().getAmount(), limitOrder.getTradableAmount()));
            } else if (limitOrder.getType() == Order.OrderType.ASK) {
                response = this.btcchina.sellOrder(this.signatureCreator, nonce, new BTCChinaSellOrderRequest(limitOrder.getLimitPrice().getAmount(), limitOrder.getTradableAmount()));
            }
            if (((Boolean)response.getResult()).booleanValue()) {
                orderId = "";
            }
        }
        return orderId;
    }

    public boolean cancelOrder(String orderId) throws IOException {
        BTCChinaBooleanResponse response = this.btcchina.cancelOrder(this.signatureCreator, BTCChinaUtils.getNonce(), new BTCChinaCancelOrderRequest(Long.parseLong(orderId)));
        return (Boolean)response.getResult();
    }

    public Trades getTradeHistory(Object ... arguments) throws IOException {
        throw new NotYetImplementedForExchangeException();
    }
}

