/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.kraken.service.polling;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.kraken.Kraken;
import com.xeiam.xchange.kraken.KrakenAdapters;
import com.xeiam.xchange.kraken.KrakenUtils;
import com.xeiam.xchange.kraken.dto.marketdata.KrakenAssetPairsResult;
import com.xeiam.xchange.kraken.dto.marketdata.KrakenDepth;
import com.xeiam.xchange.kraken.dto.marketdata.KrakenDepthResult;
import com.xeiam.xchange.kraken.dto.marketdata.KrakenTicker;
import com.xeiam.xchange.kraken.dto.marketdata.KrakenTickerResult;
import com.xeiam.xchange.kraken.dto.marketdata.KrakenTrades;
import com.xeiam.xchange.kraken.dto.marketdata.KrakenTradesResult;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import com.xeiam.xchange.utils.Assert;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import si.mazi.rescu.RestProxyFactory;

public class KrakenPollingMarketDataService
extends BasePollingExchangeService
implements PollingMarketDataService {
    private static final long PARTIAL_ORDERBOOK_SIZE = 200L;
    private final Kraken kraken;

    public KrakenPollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        Assert.notNull((Object)exchangeSpecification.getSslUri(), (String)"Exchange specification URI cannot be null");
        this.kraken = (Kraken)RestProxyFactory.createProxy(Kraken.class, (String)exchangeSpecification.getSslUri());
    }

    public List<CurrencyPair> getExchangeSymbols() {
        KrakenAssetPairsResult krakenAssetPairs = null;
        try {
            krakenAssetPairs = this.kraken.getAssetPairs();
        }
        catch (IOException e) {
            throw new ExchangeException("Network error fetching exchange symbols!!!");
        }
        if (krakenAssetPairs.getError().length > 0) {
            throw new ExchangeException(krakenAssetPairs.getError().toString());
        }
        return KrakenAdapters.adaptCurrencyPairs(((Map)krakenAssetPairs.getResult()).keySet());
    }

    public Ticker getTicker(String tradableIdentifier, String currency) throws IOException {
        String krakenCurrencyPair = KrakenUtils.createKrakenCurrencyPair(tradableIdentifier, currency);
        KrakenTickerResult krakenTickerResult = this.kraken.getTicker(krakenCurrencyPair);
        if (krakenTickerResult.getError().length > 0) {
            throw new ExchangeException(Arrays.toString(krakenTickerResult.getError()));
        }
        KrakenTicker krakenTicker = (KrakenTicker)((Map)krakenTickerResult.getResult()).get(krakenCurrencyPair);
        return KrakenAdapters.adaptTicker(krakenTicker, currency, tradableIdentifier);
    }

    public OrderBook getPartialOrderBook(String tradableIdentifier, String currency) throws IOException {
        return this.getOrderBook(tradableIdentifier, currency, 200L);
    }

    public OrderBook getFullOrderBook(String tradableIdentifier, String currency) throws IOException {
        return this.getOrderBook(tradableIdentifier, currency, null);
    }

    private OrderBook getOrderBook(String tradableIdentifier, String currency, Long count) throws IOException {
        String krakenCurrencyPair = KrakenUtils.createKrakenCurrencyPair(tradableIdentifier, currency);
        KrakenDepthResult krakenDepthReturn = this.kraken.getDepth(krakenCurrencyPair, count);
        if (krakenDepthReturn.getError().length > 0) {
            throw new ExchangeException(Arrays.toString(krakenDepthReturn.getError()));
        }
        KrakenDepth krakenDepth = (KrakenDepth)((Map)krakenDepthReturn.getResult()).get(krakenCurrencyPair);
        List<LimitOrder> bids = KrakenAdapters.adaptOrders(krakenDepth.getBids(), currency, tradableIdentifier, "bids");
        List<LimitOrder> asks = KrakenAdapters.adaptOrders(krakenDepth.getAsks(), currency, tradableIdentifier, "asks");
        Comparator<LimitOrder> dateComparator = new Comparator<LimitOrder>(){

            @Override
            public int compare(LimitOrder o1, LimitOrder o2) {
                return o1.getTimestamp().compareTo(o2.getTimestamp());
            }
        };
        bids.addAll(asks);
        Date timeStamp = Collections.max(bids, dateComparator).getTimestamp();
        return new OrderBook(timeStamp, asks, bids);
    }

    public Trades getTrades(String tradableIdentifier, String currency, Object ... args) throws IOException {
        String currencyPair = KrakenUtils.createKrakenCurrencyPair(tradableIdentifier, currency);
        KrakenTradesResult krakenTrades = this.kraken.getTrades(currencyPair);
        if (krakenTrades.getError().length > 0) {
            throw new ExchangeException(krakenTrades.getError().toString());
        }
        Trades trades = KrakenAdapters.adaptTrades(((KrakenTrades)krakenTrades.getResult()).getTradesPerCurrencyPair(currencyPair), currency, tradableIdentifier, ((KrakenTrades)krakenTrades.getResult()).getLast());
        return trades;
    }
}

