/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.btce.dto.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Map;

public class BTCEAccountInfo {
    private final int transactionCount;
    private final int openOrders;
    private final long serverTime;
    private final Rights rights;
    private final Map<String, BigDecimal> funds;

    public BTCEAccountInfo(@JsonProperty(value="transaction_count") int transactionCount, @JsonProperty(value="open_orders") int openOrders, @JsonProperty(value="server_time") long serverTime, @JsonProperty(value="rights") Rights rights, @JsonProperty(value="funds") Map<String, BigDecimal> funds) {
        this.transactionCount = transactionCount;
        this.openOrders = openOrders;
        this.serverTime = serverTime;
        this.rights = rights;
        this.funds = funds;
    }

    public int getTransactionCount() {
        return this.transactionCount;
    }

    public int getOpenOrders() {
        return this.openOrders;
    }

    public long getServerTime() {
        return this.serverTime;
    }

    public Rights getRights() {
        return this.rights;
    }

    public Map<String, BigDecimal> getFunds() {
        return this.funds;
    }

    public String toString() {
        return MessageFormat.format("BTCEAccountInfo[transactionCount={0}, openOrders={1}, serverTime={2}, rights={3}, funds=''{4}''']", this.transactionCount, this.openOrders, this.serverTime, this.rights, this.funds);
    }

    public static class Rights {
        private final boolean info;
        private final boolean trade;
        private final boolean withdraw;

        private Rights(@JsonProperty(value="info") boolean info, @JsonProperty(value="trade") boolean trade, @JsonProperty(value="withdraw") boolean withdraw) {
            this.info = info;
            this.trade = trade;
            this.withdraw = withdraw;
        }

        public boolean isInfo() {
            return this.info;
        }

        public boolean isTrade() {
            return this.trade;
        }

        public boolean isWithdraw() {
            return this.withdraw;
        }

        public String toString() {
            return MessageFormat.format("Rights[info={0}, trade={1}, withdraw={2}]", this.info, this.trade, this.withdraw);
        }
    }
}

