/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.btce.service;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestInvocation;

public class BTCEHmacPostBodyDigest
implements ParamsDigest {
    private static final String HMAC_SHA_512 = "HmacSHA512";
    private final Mac mac;

    private BTCEHmacPostBodyDigest(String secretKeyBase64) throws IllegalArgumentException {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secretKeyBase64.getBytes("UTF-8"), HMAC_SHA_512);
            this.mac = Mac.getInstance(HMAC_SHA_512);
            this.mac.init(secretKey);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Illegal encoding, check the code.", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key for hmac initialization.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Illegal algorithm for post body digest. Check the implementation.");
        }
    }

    public static BTCEHmacPostBodyDigest createInstance(String secretKeyBase64) throws IllegalArgumentException {
        return secretKeyBase64 == null ? null : new BTCEHmacPostBodyDigest(secretKeyBase64);
    }

    public String digestParams(RestInvocation RestInvocation2) {
        try {
            String postBody = RestInvocation2.getRequestBody();
            this.mac.update(postBody.getBytes("UTF-8"));
            return String.format("%0128x", new BigInteger(1, this.mac.doFinal()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Illegal encoding, check the code.", e);
        }
    }
}

