/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.btce.service.polling;

import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotAvailableFromExchangeException;
import com.xeiam.xchange.btce.BTCE;
import com.xeiam.xchange.btce.BTCEAdapters;
import com.xeiam.xchange.btce.BTCEUtils;
import com.xeiam.xchange.btce.dto.marketdata.BTCEDepth;
import com.xeiam.xchange.btce.dto.marketdata.BTCETicker;
import com.xeiam.xchange.btce.dto.marketdata.BTCETrade;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import com.xeiam.xchange.utils.Assert;
import java.io.IOException;
import java.util.List;
import si.mazi.rescu.RestProxyFactory;

public class BTCEPollingMarketDataService
implements PollingMarketDataService {
    private final BTCE btce;

    public BTCEPollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        this.btce = (BTCE)RestProxyFactory.createProxy(BTCE.class, (String)exchangeSpecification.getSslUri());
    }

    public Ticker getTicker(String tradableIdentifier, String currency) throws IOException {
        this.verify(tradableIdentifier, currency);
        BTCETicker btceTicker = this.btce.getTicker(tradableIdentifier.toLowerCase(), currency.toLowerCase());
        return BTCEAdapters.adaptTicker(btceTicker, tradableIdentifier, currency);
    }

    public OrderBook getPartialOrderBook(String tradableIdentifier, String currency) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public OrderBook getFullOrderBook(String tradableIdentifier, String currency) throws IOException {
        this.verify(tradableIdentifier, currency);
        BTCEDepth btceDepth = this.btce.getFullDepth(tradableIdentifier.toLowerCase(), currency.toLowerCase());
        List<LimitOrder> asks = BTCEAdapters.adaptOrders(btceDepth.getAsks(), tradableIdentifier, currency, "ask", "");
        List<LimitOrder> bids = BTCEAdapters.adaptOrders(btceDepth.getBids(), tradableIdentifier, currency, "bid", "");
        return new OrderBook(null, asks, bids);
    }

    public Trades getTrades(String tradableIdentifier, String currency, Object ... args) throws IOException {
        this.verify(tradableIdentifier, currency);
        BTCETrade[] BTCETrades = this.btce.getTrades(tradableIdentifier.toLowerCase(), currency.toLowerCase());
        return BTCEAdapters.adaptTrades(BTCETrades);
    }

    private void verify(String tradableIdentifier, String currency) throws IOException {
        Assert.notNull((Object)tradableIdentifier, (String)"tradableIdentifier cannot be null");
        Assert.notNull((Object)currency, (String)"currency cannot be null");
        Assert.isTrue((boolean)BTCEUtils.isValidCurrencyPair(new CurrencyPair(tradableIdentifier, currency)), (String)("currencyPair is not valid:" + tradableIdentifier + " " + currency));
    }

    public List<CurrencyPair> getExchangeSymbols() {
        return BTCEUtils.CURRENCY_PAIRS;
    }
}

