/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.btce.service.polling;

import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.btce.BTCEAdapters;
import com.xeiam.xchange.btce.BTCEAuthenticated;
import com.xeiam.xchange.btce.BTCEUtils;
import com.xeiam.xchange.btce.dto.trade.BTCECancelOrderReturn;
import com.xeiam.xchange.btce.dto.trade.BTCEOpenOrdersReturn;
import com.xeiam.xchange.btce.dto.trade.BTCEOrder;
import com.xeiam.xchange.btce.dto.trade.BTCEPlaceOrderResult;
import com.xeiam.xchange.btce.dto.trade.BTCEPlaceOrderReturn;
import com.xeiam.xchange.btce.dto.trade.BTCETradeHistoryReturn;
import com.xeiam.xchange.btce.service.polling.BTCEBasePollingService;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.dto.trade.MarketOrder;
import com.xeiam.xchange.dto.trade.OpenOrders;
import com.xeiam.xchange.service.polling.PollingTradeService;
import com.xeiam.xchange.utils.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class BTCEPollingTradeService
extends BTCEBasePollingService
implements PollingTradeService {
    public BTCEPollingTradeService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
    }

    public OpenOrders getOpenOrders() throws IOException {
        BTCEOpenOrdersReturn orders = this.btce.ActiveOrders(this.apiKey, this.signatureCreator, this.nextNonce(), null);
        if ("no orders".equals(orders.getError())) {
            return new OpenOrders(new ArrayList());
        }
        this.checkResult(orders);
        return BTCEAdapters.adaptOrders((Map)orders.getReturnValue());
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        throw new UnsupportedOperationException("Market orders not supported by BTCE API.");
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        Assert.isTrue((boolean)BTCEUtils.isValidCurrencyPair(new CurrencyPair(limitOrder.getTradableIdentifier(), limitOrder.getTransactionCurrency())), (String)("currencyPair is not valid:" + limitOrder.getTradableIdentifier() + " " + limitOrder.getTransactionCurrency()));
        String pair = String.format("%s_%s", limitOrder.getTradableIdentifier(), limitOrder.getTransactionCurrency()).toLowerCase();
        BTCEOrder.Type type = limitOrder.getType() == Order.OrderType.BID ? BTCEOrder.Type.buy : BTCEOrder.Type.sell;
        BTCEPlaceOrderReturn ret = this.btce.Trade(this.apiKey, this.signatureCreator, this.nextNonce(), pair, type, limitOrder.getLimitPrice().getAmount(), limitOrder.getTradableAmount());
        this.checkResult(ret);
        return Long.toString(((BTCEPlaceOrderResult)ret.getReturnValue()).getOrderId());
    }

    public boolean cancelOrder(String orderId) throws IOException {
        BTCECancelOrderReturn ret = this.btce.CancelOrder(this.apiKey, this.signatureCreator, this.nextNonce(), Long.parseLong(orderId));
        this.checkResult(ret);
        return ret.isSuccess();
    }

    public Trades getTradeHistory(Object ... arguments) throws IOException {
        Long numberOfTransactions = Long.MAX_VALUE;
        String tradableIdentifier = "";
        String transactionCurrency = "";
        try {
            numberOfTransactions = (Long)arguments[0];
            tradableIdentifier = (String)arguments[1];
            transactionCurrency = (String)arguments[2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        String pair = String.format("%s_%s", tradableIdentifier, transactionCurrency).toLowerCase();
        BTCETradeHistoryReturn btceTradeHistory = this.btce.TradeHistory(this.apiKey, this.signatureCreator, this.nextNonce(), null, numberOfTransactions, null, null, BTCEAuthenticated.SortOrder.DESC, null, null, pair);
        this.checkResult(btceTradeHistory);
        return BTCEAdapters.adaptTradeHistory((Map)btceTradeHistory.getReturnValue());
    }
}

