/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitcurex.service.polling;

import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotAvailableFromExchangeException;
import com.xeiam.xchange.bitcurex.Bitcurex;
import com.xeiam.xchange.bitcurex.BitcurexAdapters;
import com.xeiam.xchange.bitcurex.BitcurexUtils;
import com.xeiam.xchange.bitcurex.dto.marketdata.BitcurexDepth;
import com.xeiam.xchange.bitcurex.dto.marketdata.BitcurexTicker;
import com.xeiam.xchange.bitcurex.dto.marketdata.BitcurexTrade;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import com.xeiam.xchange.utils.Assert;
import java.io.IOException;
import java.util.List;
import si.mazi.rescu.RestProxyFactory;

public class BitcurexPollingMarketDataService
extends BasePollingExchangeService
implements PollingMarketDataService {
    private Bitcurex bitcurex;

    public BitcurexPollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
    }

    public Ticker getTicker(String tradableIdentifier, String currency) throws IOException {
        this.verify(tradableIdentifier, currency);
        this.bitcurex = (Bitcurex)RestProxyFactory.createProxy(Bitcurex.class, (String)("https://" + currency + ".bitcurex.com"));
        BitcurexTicker bitcurexTicker = this.bitcurex.getTicker(currency);
        return BitcurexAdapters.adaptTicker(bitcurexTicker, currency, tradableIdentifier);
    }

    public OrderBook getPartialOrderBook(String tradableIdentifier, String currency) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public OrderBook getFullOrderBook(String tradableIdentifier, String currency) throws IOException {
        this.verify(tradableIdentifier, currency);
        this.bitcurex = (Bitcurex)RestProxyFactory.createProxy(Bitcurex.class, (String)("https://" + currency + ".bitcurex.com"));
        BitcurexDepth bitcurexDepth = this.bitcurex.getFullDepth(currency);
        List<LimitOrder> asks = BitcurexAdapters.adaptOrders(bitcurexDepth.getAsks(), currency, Order.OrderType.ASK, "");
        List<LimitOrder> bids = BitcurexAdapters.adaptOrders(bitcurexDepth.getBids(), currency, Order.OrderType.BID, "");
        return new OrderBook(null, asks, bids);
    }

    public Trades getTrades(String tradableIdentifier, String currency, Object ... args) throws IOException {
        this.verify(tradableIdentifier, currency);
        this.bitcurex = (Bitcurex)RestProxyFactory.createProxy(Bitcurex.class, (String)("https://" + currency + ".bitcurex.com"));
        BitcurexTrade[] bitcurexTrades = this.bitcurex.getTrades(currency);
        return BitcurexAdapters.adaptTrades(bitcurexTrades, currency, tradableIdentifier);
    }

    private void verify(String tradableIdentifier, String currency) {
        Assert.notNull((Object)tradableIdentifier, (String)"tradableIdentifier cannot be null");
        Assert.notNull((Object)currency, (String)"currency cannot be null");
        Assert.isTrue((boolean)BitcurexUtils.isValidCurrencyPair(new CurrencyPair(tradableIdentifier, currency)), (String)("currencyPair is not valid:" + tradableIdentifier + " " + currency));
    }

    public List<CurrencyPair> getExchangeSymbols() {
        return BitcurexUtils.CURRENCY_PAIRS;
    }
}

