/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitstamp;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.currency.CurrencyPair;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public final class BitstampUtils {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final List<CurrencyPair> CURRENCY_PAIRS = Arrays.asList(CurrencyPair.BTC_USD);

    private BitstampUtils() {
    }

    public static boolean isValidCurrencyPair(CurrencyPair currencyPair) {
        return CURRENCY_PAIRS.contains(currencyPair);
    }

    public static Date parseDate(String dateString) {
        try {
            return DATE_FORMAT.parse(dateString);
        }
        catch (ParseException e) {
            throw new ExchangeException("Illegal date/time format", (Throwable)e);
        }
    }

    public static long getNonce() {
        return System.currentTimeMillis();
    }
}

