/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitstamp.service.polling;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotAvailableFromExchangeException;
import com.xeiam.xchange.bitstamp.Bitstamp;
import com.xeiam.xchange.bitstamp.BitstampAdapters;
import com.xeiam.xchange.bitstamp.BitstampUtils;
import com.xeiam.xchange.bitstamp.dto.marketdata.BitstampOrderBook;
import com.xeiam.xchange.bitstamp.dto.marketdata.BitstampTicker;
import com.xeiam.xchange.bitstamp.dto.marketdata.BitstampTransaction;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import com.xeiam.xchange.utils.Assert;
import java.io.IOException;
import java.util.List;
import si.mazi.rescu.RestProxyFactory;

public class BitstampPollingMarketDataService
extends BasePollingExchangeService
implements PollingMarketDataService {
    private final Bitstamp bitstamp;

    public BitstampPollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        this.bitstamp = (Bitstamp)RestProxyFactory.createProxy(Bitstamp.class, (String)exchangeSpecification.getSslUri());
    }

    public Ticker getTicker(String tradableIdentifier, String currency) throws IOException {
        this.verify(tradableIdentifier, currency);
        BitstampTicker bitstampTicker = this.bitstamp.getTicker();
        return BitstampAdapters.adaptTicker(bitstampTicker, tradableIdentifier, currency);
    }

    public OrderBook getPartialOrderBook(String tradableIdentifier, String currency) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public OrderBook getFullOrderBook(String tradableIdentifier, String currency) throws IOException {
        this.verify(tradableIdentifier, currency);
        BitstampOrderBook bitstampOrderBook = this.bitstamp.getOrderBook();
        return BitstampAdapters.adaptOrders(bitstampOrderBook, tradableIdentifier, currency);
    }

    public Trades getTrades(String tradableIdentifier, String currency, Object ... args) throws IOException {
        this.verify(tradableIdentifier, currency);
        BitstampTransaction[] transactions = null;
        if (args.length == 0) {
            transactions = this.bitstamp.getTransactions();
        } else if (args.length == 1) {
            BitstampTime bitstampTime = (BitstampTime)((Object)args[0]);
            transactions = this.bitstamp.getTransactions(bitstampTime.toString().toLowerCase());
        } else {
            throw new ExchangeException("Invalid argument length. Must be 0, 1, or 2.");
        }
        return BitstampAdapters.adaptTrades(transactions, tradableIdentifier, currency);
    }

    private void verify(String tradableIdentifier, String currency) {
        Assert.notNull((Object)tradableIdentifier, (String)"tradableIdentifier cannot be null");
        Assert.notNull((Object)currency, (String)"currency cannot be null");
        Assert.isTrue((boolean)BitstampUtils.isValidCurrencyPair(new CurrencyPair(tradableIdentifier, currency)), (String)("currencyPair is not valid:" + tradableIdentifier + " " + currency));
    }

    public List<CurrencyPair> getExchangeSymbols() {
        return BitstampUtils.CURRENCY_PAIRS;
    }

    public static enum BitstampTime {
        HOUR,
        MINUTE;

    }
}

