/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitcoinaverage;

import com.xeiam.xchange.bitcoinaverage.dto.marketdata.BitcoinAverageTicker;
import com.xeiam.xchange.currency.MoneyUtils;
import com.xeiam.xchange.dto.marketdata.Ticker;
import java.math.BigDecimal;
import java.util.Date;
import org.joda.money.BigMoney;

public final class BitcoinAverageAdapters {
    private BitcoinAverageAdapters() {
    }

    public static Ticker adaptTicker(BitcoinAverageTicker bitcoinAverageTicker, String currency, String tradableIdentifier) {
        BigMoney last = MoneyUtils.parse((String)(currency + " " + bitcoinAverageTicker.getLast()));
        BigMoney bid = MoneyUtils.parse((String)(currency + " " + bitcoinAverageTicker.getBid()));
        BigMoney ask = MoneyUtils.parse((String)(currency + " " + bitcoinAverageTicker.getAsk()));
        Date timestamp = bitcoinAverageTicker.getTimestamp();
        BigDecimal volume = bitcoinAverageTicker.getVolume();
        return Ticker.TickerBuilder.newInstance().withTradableIdentifier(tradableIdentifier).withLast(last).withBid(bid).withAsk(ask).withVolume(volume).withTimestamp(timestamp).build();
    }
}

