/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitcoinaverage.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class BitcoinAverageTicker {
    private final BigDecimal last;
    private final BigDecimal ask;
    private final BigDecimal bid;
    private final BigDecimal avg;
    private final BigDecimal volume;
    private final String timestamp;

    public BitcoinAverageTicker(@JsonProperty(value="ask") BigDecimal ask, @JsonProperty(value="bid") BigDecimal bid, @JsonProperty(value="total_vol") BigDecimal volume, @JsonProperty(value="last") BigDecimal last, @JsonProperty(value="24h_avg") BigDecimal avg, @JsonProperty(value="timestamp") String timestamp) {
        this.ask = ask;
        this.bid = bid;
        this.volume = volume;
        this.last = last;
        this.avg = avg;
        this.timestamp = timestamp;
    }

    public BigDecimal getLast() {
        return this.last;
    }

    public BigDecimal getAsk() {
        return this.ask;
    }

    public BigDecimal getBid() {
        return this.bid;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public BigDecimal getAvg() {
        return this.avg;
    }

    public Date getTimestamp() {
        try {
            return new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.getDefault()).parse(this.timestamp);
        }
        catch (IllegalArgumentException e) {
            return new Date();
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public String toString() {
        return "BitcoinAverageTicker [last=" + this.last + ", ask=" + this.ask + ", bid=" + this.bid + ", volume=" + this.volume + ", avg=" + this.avg + ", timestamp=" + this.timestamp + "]";
    }
}

