/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.bitcoinaverage.service.polling;

import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotAvailableFromExchangeException;
import com.xeiam.xchange.bitcoinaverage.BitcoinAverage;
import com.xeiam.xchange.bitcoinaverage.BitcoinAverageAdapters;
import com.xeiam.xchange.bitcoinaverage.BitcoinAverageUtils;
import com.xeiam.xchange.bitcoinaverage.dto.marketdata.BitcoinAverageTicker;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.ExchangeInfo;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import com.xeiam.xchange.utils.Assert;
import java.io.IOException;
import java.util.List;
import si.mazi.rescu.RestProxyFactory;

public class BitcoinAveragePollingMarketDataService
extends BasePollingExchangeService
implements PollingMarketDataService {
    private final BitcoinAverage bitcoinAverage;

    public BitcoinAveragePollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        this.bitcoinAverage = (BitcoinAverage)RestProxyFactory.createProxy(BitcoinAverage.class, (String)exchangeSpecification.getSslUri());
    }

    public Ticker getTicker(String tradableIdentifier, String currency) throws IOException {
        this.verify(tradableIdentifier, currency);
        BitcoinAverageTicker bitcoinAverageTicker = this.bitcoinAverage.getTicker(currency);
        return BitcoinAverageAdapters.adaptTicker(bitcoinAverageTicker, currency, tradableIdentifier);
    }

    public OrderBook getOrderBook(String tradableIdentifier, String currency, Object ... args) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public Trades getTrades(String tradableIdentifier, String currency, Object ... args) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public ExchangeInfo getExchangeInfo() throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    private void verify(String tradableIdentifier, String currency) throws IOException {
        Assert.notNull((Object)tradableIdentifier, (String)"tradableIdentifier cannot be null");
        Assert.notNull((Object)currency, (String)"currency cannot be null");
        Assert.isTrue((boolean)BitcoinAverageUtils.isValidCurrencyPair(new CurrencyPair(tradableIdentifier, currency)), (String)("currencyPair is not valid:" + tradableIdentifier + " " + currency));
    }

    public List<CurrencyPair> getExchangeSymbols() {
        return BitcoinAverageUtils.CURRENCY_PAIRS;
    }
}

