/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.btce.v3.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.xeiam.xchange.btce.v3.BTCEUtils;
import com.xeiam.xchange.btce.v3.dto.marketdata.BTCEDepth;
import java.util.Map;

public class BTCEDepthWrapper {
    private final Map<String, BTCEDepth> depthMap;

    @JsonCreator
    public BTCEDepthWrapper(Map<String, BTCEDepth> resultV3) {
        this.depthMap = resultV3;
    }

    public Map<String, BTCEDepth> getDepthMap() {
        return this.depthMap;
    }

    public BTCEDepth getDepth(String tradableIdentifier, String currency) {
        String pair = BTCEUtils.getPair(tradableIdentifier, currency);
        BTCEDepth result = null;
        if (this.depthMap.containsKey(pair)) {
            result = this.depthMap.get(pair);
        }
        return result;
    }

    public String toString() {
        return "BTCEDepthV3 [map=" + this.depthMap.toString() + "]";
    }
}

