/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.btce.v3.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.xeiam.xchange.btce.v3.BTCEUtils;
import com.xeiam.xchange.btce.v3.dto.marketdata.BTCETicker;
import java.util.Map;

public class BTCETickerWrapper {
    private final Map<String, BTCETicker> tickerMap;

    @JsonCreator
    public BTCETickerWrapper(Map<String, BTCETicker> resultV3) {
        this.tickerMap = resultV3;
    }

    public Map<String, BTCETicker> getTickerMap() {
        return this.tickerMap;
    }

    public BTCETicker getTicker(String tradableIdentifier, String currency) {
        String pair = BTCEUtils.getPair(tradableIdentifier, currency);
        BTCETicker result = null;
        if (this.tickerMap.containsKey(pair)) {
            result = this.tickerMap.get(pair);
        }
        return result;
    }

    public String toString() {
        return "BTCETickerV3 [map=" + this.tickerMap.toString() + "]";
    }
}

