/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.btce.v3.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.xeiam.xchange.btce.v3.BTCEUtils;
import com.xeiam.xchange.btce.v3.dto.marketdata.BTCETrade;
import java.util.Map;

public class BTCETradesWrapper {
    private final Map<String, BTCETrade[]> tradesMap;

    @JsonCreator
    public BTCETradesWrapper(Map<String, BTCETrade[]> tradesMap) {
        this.tradesMap = tradesMap;
    }

    public Map<String, BTCETrade[]> getTradesMap() {
        return this.tradesMap;
    }

    public BTCETrade[] getTrades(String tradableIdentifier, String currency) {
        String pair = BTCEUtils.getPair(tradableIdentifier, currency);
        BTCETrade[] result = null;
        if (this.tradesMap.containsKey(pair)) {
            result = this.tradesMap.get(pair);
        }
        return result;
    }

    public String toString() {
        return "BTCETradesV3 [map=" + this.tradesMap.toString() + "]";
    }
}

