/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.btce.v3.service.polling;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.btce.v3.BTCE;
import com.xeiam.xchange.btce.v3.BTCEAdapters;
import com.xeiam.xchange.btce.v3.BTCEUtils;
import com.xeiam.xchange.btce.v3.dto.marketdata.BTCEDepthWrapper;
import com.xeiam.xchange.btce.v3.dto.marketdata.BTCEExchangeInfo;
import com.xeiam.xchange.btce.v3.dto.marketdata.BTCETickerWrapper;
import com.xeiam.xchange.btce.v3.dto.marketdata.BTCETrade;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.ExchangeInfo;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import com.xeiam.xchange.utils.Assert;
import java.io.IOException;
import java.util.List;
import si.mazi.rescu.RestProxyFactory;

public class BTCEPollingMarketDataService
implements PollingMarketDataService {
    protected final BTCE btce;
    private static final int FULL_SIZE = 2000;

    public BTCEPollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        this.btce = (BTCE)RestProxyFactory.createProxy(BTCE.class, (String)exchangeSpecification.getSslUri());
    }

    public Ticker getTicker(String tradableIdentifier, String currency) throws IOException {
        this.verify(tradableIdentifier, currency);
        BTCETickerWrapper btceTickerWrapper = this.btce.getTicker(tradableIdentifier.toLowerCase(), currency.toLowerCase(), 1);
        return BTCEAdapters.adaptTicker(btceTickerWrapper.getTicker(tradableIdentifier, currency), tradableIdentifier, currency);
    }

    public OrderBook getOrderBook(String tradableIdentifier, String currency, Object ... args) throws IOException {
        this.verify(tradableIdentifier, currency);
        BTCEDepthWrapper btceDepthWrapper = null;
        if (args.length > 0) {
            Object arg = args[0];
            if (!(arg instanceof Integer) || (Integer)arg < 1 || (Integer)arg > 2000) {
                throw new ExchangeException("Orderbook size argument must be an Integer in the range: (1, 2000)!");
            }
            btceDepthWrapper = this.btce.getDepth(tradableIdentifier.toLowerCase(), currency.toLowerCase(), (Integer)arg, 1);
        } else {
            btceDepthWrapper = this.btce.getDepth(tradableIdentifier.toLowerCase(), currency.toLowerCase(), 2000, 1);
        }
        List<LimitOrder> asks = BTCEAdapters.adaptOrders(btceDepthWrapper.getDepth(tradableIdentifier, currency).getAsks(), tradableIdentifier, currency, "ask", "");
        List<LimitOrder> bids = BTCEAdapters.adaptOrders(btceDepthWrapper.getDepth(tradableIdentifier, currency).getBids(), tradableIdentifier, currency, "bid", "");
        return new OrderBook(null, asks, bids);
    }

    public Trades getTrades(String tradableIdentifier, String currency, Object ... args) throws IOException {
        this.verify(tradableIdentifier, currency);
        int numberOfItems = -1;
        try {
            numberOfItems = (Integer)args[0];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        BTCETrade[] bTCETrades = null;
        bTCETrades = numberOfItems == -1 ? this.btce.getTrades(tradableIdentifier.toLowerCase(), currency.toLowerCase(), 2000, 1).getTrades(tradableIdentifier.toLowerCase(), currency.toLowerCase()) : this.btce.getTrades(tradableIdentifier.toLowerCase(), currency.toLowerCase(), numberOfItems, 1).getTrades(tradableIdentifier.toLowerCase(), currency.toLowerCase());
        return BTCEAdapters.adaptTrades(bTCETrades, tradableIdentifier, currency);
    }

    private void verify(String tradableIdentifier, String currency) throws IOException {
        Assert.notNull((Object)tradableIdentifier, (String)"tradableIdentifier cannot be null");
        Assert.notNull((Object)currency, (String)"currency cannot be null");
        Assert.isTrue((boolean)BTCEUtils.isValidCurrencyPair(new CurrencyPair(tradableIdentifier, currency)), (String)("currencyPair is not valid:" + tradableIdentifier + " " + currency));
    }

    public List<CurrencyPair> getExchangeSymbols() {
        return BTCEUtils.CURRENCY_PAIRS;
    }

    public ExchangeInfo getExchangeInfo() throws IOException {
        BTCEExchangeInfo bTCEExchangeInfo = this.btce.getInfo();
        return BTCEAdapters.adaptExchangeInfo(bTCEExchangeInfo);
    }
}

