/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Params
implements Serializable {
    private Map<String, Object> data = new LinkedHashMap<String, Object>();

    private Params() {
    }

    public static Params of() {
        return new Params();
    }

    public static Params of(String param, Object value) {
        return Params.of().add(param, value);
    }

    public static Params of(String p1, Object v1, String p2, Object v2) {
        return Params.of(p1, v1).add(p2, v2);
    }

    public static Params of(String p1, Object v1, String p2, Object v2, String p3, Object v3) {
        return Params.of(p1, v1, p2, v2).add(p3, v3);
    }

    public static Params of(String p1, Object v1, String p2, Object v2, String p3, Object v3, String p4, Object v4) {
        return Params.of(p1, v1, p2, v2, p3, v3).add(p4, v4);
    }

    public Params add(String param, Object value) {
        this.data.put(param, value);
        return this;
    }

    private String toQueryString(boolean encode) {
        StringBuilder b = new StringBuilder();
        for (String param : this.data.keySet()) {
            if (!this.isParamSet(param)) continue;
            if (b.length() > 0) {
                b.append('&');
            }
            b.append(param).append('=').append(this.encode(this.getParamValueAsString(param), encode));
        }
        return b.toString();
    }

    private String encode(String data, boolean encode) {
        try {
            return encode ? URLEncoder.encode(data, "UTF-8") : data;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Illegal encoding, fix the code.", e);
        }
    }

    public String asQueryString() {
        return this.toQueryString(true);
    }

    public String asFormEncodedRequestBody() {
        return this.toQueryString(false);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public String applyToPath(String path) {
        for (String paramName : this.data.keySet()) {
            if (!this.isParamSet(paramName)) {
                throw new IllegalArgumentException("The value of '" + paramName + "' path parameter was not specified.");
            }
            path = path.replace("{" + paramName + "}", this.getParamValueAsString(paramName));
        }
        return path;
    }

    public Map<String, String> asHttpHeaders() {
        LinkedHashMap<String, String> stringMap = new LinkedHashMap<String, String>();
        for (String key : this.data.keySet()) {
            if (!this.isParamSet(key)) continue;
            stringMap.put(key, this.getParamValueAsString(key));
        }
        return stringMap;
    }

    private String getParamValueAsString(String key) {
        Object paramValue = this.getParamValue(key);
        return paramValue.toString();
    }

    public void digestAll(RestInvocation invocationParams) {
        for (String paramName : this.data.keySet()) {
            Object paramValue = this.getParamValue(paramName);
            if (!(paramValue instanceof ParamsDigest)) continue;
            this.data.put(paramName, ((ParamsDigest)paramValue).digestParams(invocationParams));
        }
    }

    public boolean isParamSet(String paramName) {
        return this.data.containsKey(paramName) && this.getParamValue(paramName) != null;
    }

    public Object getParamValue(String paramName) {
        return this.data.get(paramName);
    }

    public String toString() {
        return this.toQueryString(false);
    }
}

