/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Path;
import si.mazi.rescu.HttpTemplate;
import si.mazi.rescu.RestInvocation;
import si.mazi.rescu.RestMethodMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestInvocationHandler
implements InvocationHandler {
    private final HttpTemplate httpTemplate;
    private final String intfacePath;
    private final String baseUrl;
    private final Map<Method, RestMethodMetadata> cache = new HashMap<Method, RestMethodMetadata>();

    public RestInvocationHandler(Class<?> restInterface, String url) {
        this.intfacePath = restInterface.getAnnotation(Path.class).value();
        this.baseUrl = url;
        this.httpTemplate = new HttpTemplate();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RestMethodMetadata restMethodMetadata = this.getMetadata(method);
        RestInvocation params = new RestInvocation(restMethodMetadata, args);
        return this.invokeHttp(params);
    }

    private RestMethodMetadata getMetadata(Method method) {
        RestMethodMetadata metadata = this.cache.get(method);
        if (metadata == null) {
            metadata = RestMethodMetadata.create(method, this.baseUrl, this.intfacePath);
            this.cache.put(method, metadata);
        }
        return metadata;
    }

    protected Object invokeHttp(RestInvocation invocation) throws IOException {
        RestMethodMetadata methodMetadata = invocation.getRestMethodMetadata();
        return this.httpTemplate.executeRequest(invocation.getInvocationUrl(), methodMetadata.returnType, invocation.getRequestBody(), invocation.getHttpHeaders(), methodMetadata.httpMethod, invocation.getContentType(), methodMetadata.exceptionType);
    }
}

