/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.btcchina.service;

import com.xeiam.xchange.btcchina.BTCChinaUtils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import si.mazi.rescu.BasicAuthCredentials;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestInvocation;

public class BTCChinaDigest
implements ParamsDigest {
    private static final String HMAC_SHA1 = "HmacSHA1";
    private final Mac mac;
    private final String exchangeAccessKey;

    private BTCChinaDigest(String exchangeAccessKey, String exchangeSecretKey) throws IllegalArgumentException {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(exchangeSecretKey.getBytes(), HMAC_SHA1);
            this.mac = Mac.getInstance(HMAC_SHA1);
            this.mac.init(secretKey);
            this.exchangeAccessKey = exchangeAccessKey;
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key for hmac initialization.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Illegal algorithm for post body digest. Check the implementation.");
        }
    }

    public static BTCChinaDigest createInstance(String exchangeAccessKey, String exchangeSecretKey) throws IllegalArgumentException {
        return exchangeSecretKey == null ? null : new BTCChinaDigest(exchangeAccessKey, exchangeSecretKey);
    }

    public String digestParams(RestInvocation restInvocation) {
        String tonce = (String)restInvocation.getHttpHeaders().get("Json-Rpc-Tonce");
        String requestJson = restInvocation.getRequestBody();
        String id = "";
        String method = "";
        String params = "";
        try {
            Pattern regex = Pattern.compile("\\{\"id\":([0-9]*),\"method\":\"([^\"]*)\",\"params\":\\[([^\\]]*)\\]\\}", 98);
            Matcher regexMatcher = regex.matcher(requestJson);
            if (regexMatcher.find()) {
                id = regexMatcher.group(1);
                method = regexMatcher.group(2);
                params = regexMatcher.group(3);
            }
        }
        catch (PatternSyntaxException ex) {
            // empty catch block
        }
        String signature = String.format("tonce=%s&accesskey=%s&requestmethod=%s&id=%s&method=%s&params=%s", tonce, this.exchangeAccessKey, "post", id, method, params);
        byte[] hash = this.mac.doFinal(signature.getBytes());
        BasicAuthCredentials auth = new BasicAuthCredentials(this.exchangeAccessKey, BTCChinaUtils.bytesToHex(hash));
        return auth.digestParams(restInvocation);
    }
}

