/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.btcchina.service.polling;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotAvailableFromExchangeException;
import com.xeiam.xchange.btcchina.BTCChina;
import com.xeiam.xchange.btcchina.BTCChinaAdapters;
import com.xeiam.xchange.btcchina.BTCChinaUtils;
import com.xeiam.xchange.btcchina.dto.marketdata.BTCChinaDepth;
import com.xeiam.xchange.btcchina.dto.marketdata.BTCChinaTicker;
import com.xeiam.xchange.btcchina.dto.marketdata.BTCChinaTrade;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.ExchangeInfo;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import com.xeiam.xchange.utils.Assert;
import java.io.IOException;
import java.util.List;
import si.mazi.rescu.RestProxyFactory;

public class BTCChinaPollingMarketDataService
extends BasePollingExchangeService
implements PollingMarketDataService {
    private final BTCChina btcChina;

    public BTCChinaPollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        this.btcChina = (BTCChina)RestProxyFactory.createProxy(BTCChina.class, (String)exchangeSpecification.getSslUri());
    }

    public Ticker getTicker(String tradableIdentifier, String currency) throws IOException {
        this.verify(tradableIdentifier, currency);
        BTCChinaTicker btcChinaTicker = this.btcChina.getTicker();
        return BTCChinaAdapters.adaptTicker(btcChinaTicker, currency, tradableIdentifier);
    }

    public OrderBook getOrderBook(String tradableIdentifier, String currency, Object ... args) throws IOException {
        this.verify(tradableIdentifier, currency);
        BTCChinaDepth btcChinaDepth = this.btcChina.getFullDepth();
        List<LimitOrder> asks = BTCChinaAdapters.adaptOrders(btcChinaDepth.getAsks(), currency, Order.OrderType.ASK);
        List<LimitOrder> bids = BTCChinaAdapters.adaptOrders(btcChinaDepth.getBids(), currency, Order.OrderType.BID);
        return new OrderBook(null, asks, bids);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Trades getTrades(String tradableIdentifier, String currency, Object ... args) throws IOException {
        this.verify(tradableIdentifier, currency);
        BTCChinaTrade[] btcChinaTrades = null;
        if (args.length == 0) {
            btcChinaTrades = this.btcChina.getTrades();
            return BTCChinaAdapters.adaptTrades(btcChinaTrades, currency, tradableIdentifier);
        } else {
            if (args.length != 1) throw new ExchangeException("Invalid argument length. Must be 0, or 1");
            Object arg0 = args[0];
            if (!(arg0 instanceof Integer)) throw new ExchangeException("args[0] must be of type Integer!");
            Integer sinceTransactionID = (Integer)args[0];
            btcChinaTrades = this.btcChina.getTrades(sinceTransactionID);
        }
        return BTCChinaAdapters.adaptTrades(btcChinaTrades, currency, tradableIdentifier);
    }

    public ExchangeInfo getExchangeInfo() throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    private void verify(String tradableIdentifier, String currency) {
        Assert.notNull((Object)tradableIdentifier, (String)"tradableIdentifier cannot be null");
        Assert.notNull((Object)currency, (String)"currency cannot be null");
        Assert.isTrue((boolean)BTCChinaUtils.isValidCurrencyPair(new CurrencyPair(tradableIdentifier, currency)), (String)("currencyPair is not valid:" + tradableIdentifier + " " + currency));
    }

    public List<CurrencyPair> getExchangeSymbols() {
        return BTCChinaUtils.CURRENCY_PAIRS;
    }
}

