/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.kraken;

import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.account.AccountInfo;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trade;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.dto.trade.OpenOrders;
import com.xeiam.xchange.dto.trade.Wallet;
import com.xeiam.xchange.kraken.KrakenUtils;
import com.xeiam.xchange.kraken.dto.account.KrakenBalanceResult;
import com.xeiam.xchange.kraken.dto.marketdata.KrakenTicker;
import com.xeiam.xchange.kraken.dto.trade.KrakenOpenOrder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.joda.money.BigMoney;
import org.joda.money.CurrencyUnit;

public class KrakenAdapters {
    public static List<LimitOrder> adaptOrders(List<BigDecimal[]> orders, String currency, String tradableIdentifier, String orderType) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>(orders.size());
        for (BigDecimal[] order : orders) {
            limitOrders.add(KrakenAdapters.adaptOrder(order, orderType, currency, tradableIdentifier));
        }
        return limitOrders;
    }

    private static LimitOrder adaptOrder(BigDecimal[] order, String orderType, String currency, String tradableIdentifier) {
        Order.OrderType type = orderType.equalsIgnoreCase("asks") ? Order.OrderType.ASK : Order.OrderType.BID;
        Date timeStamp = new Date(order[2].longValue() * 1000L);
        BigMoney price = BigMoney.of((CurrencyUnit)CurrencyUnit.of((String)currency), (BigDecimal)order[0]);
        BigDecimal volume = order[1];
        return new LimitOrder(type, volume, tradableIdentifier, currency, "", timeStamp, price);
    }

    public static Ticker adaptTicker(KrakenTicker krakenTicker, String currency, String tradableIdentifier) {
        Ticker.TickerBuilder builder = new Ticker.TickerBuilder();
        builder.withAsk(BigMoney.of((CurrencyUnit)CurrencyUnit.of((String)currency), (BigDecimal)krakenTicker.getAsk()[0]));
        builder.withBid(BigMoney.of((CurrencyUnit)CurrencyUnit.of((String)currency), (BigDecimal)krakenTicker.getBid()[0]));
        builder.withLast(BigMoney.of((CurrencyUnit)CurrencyUnit.of((String)currency), (BigDecimal)krakenTicker.getClose()[0]));
        builder.withHigh(BigMoney.of((CurrencyUnit)CurrencyUnit.of((String)currency), (BigDecimal)krakenTicker.getHigh()[0]));
        builder.withLow(BigMoney.of((CurrencyUnit)CurrencyUnit.of((String)currency), (BigDecimal)krakenTicker.getLow()[0]));
        builder.withVolume(krakenTicker.getVolume()[1]);
        builder.withTradableIdentifier(tradableIdentifier);
        return builder.build();
    }

    public static Trades adaptTrades(String[][] krakenTrades, String currency, String tradableIdentifier, long last) {
        LinkedList<Trade> trades = new LinkedList<Trade>();
        for (String[] krakenTradeInformation : krakenTrades) {
            Order.OrderType type = krakenTradeInformation[3].equalsIgnoreCase("s") ? Order.OrderType.ASK : Order.OrderType.BID;
            BigDecimal tradableAmount = new BigDecimal(krakenTradeInformation[1]);
            BigMoney price = BigMoney.of((CurrencyUnit)CurrencyUnit.of((String)currency), (BigDecimal)new BigDecimal(krakenTradeInformation[0]));
            Date timestamp = new Date((long)(Double.valueOf(krakenTradeInformation[2]) * 1000.0));
            long tradeID = (long)(Double.valueOf(krakenTradeInformation[2]) * 10000.0);
            trades.add(new Trade(type, tradableAmount, tradableIdentifier, currency, price, timestamp, tradeID));
        }
        return new Trades(trades, last);
    }

    public static AccountInfo adaptBalance(KrakenBalanceResult krakenBalance, String username) {
        LinkedList<Wallet> wallets = new LinkedList<Wallet>();
        for (Map.Entry balancePair : ((Map)krakenBalance.getResult()).entrySet()) {
            String currency = KrakenUtils.getStandardCurrencyCode((String)balancePair.getKey());
            Wallet wallet = Wallet.createInstance((String)currency, (BigDecimal)((BigDecimal)balancePair.getValue()));
            wallets.add(wallet);
        }
        return new AccountInfo(username, wallets);
    }

    public static List<CurrencyPair> adaptCurrencyPairs(Collection<String> krakenCurrencyPairs) {
        LinkedList<CurrencyPair> currencyPairs = new LinkedList<CurrencyPair>();
        for (String krakenCurrencyPair : krakenCurrencyPairs) {
            String firstCurrency = krakenCurrencyPair.substring(0, 4);
            String secondCurrency = krakenCurrencyPair.substring(4);
            currencyPairs.add(new CurrencyPair(KrakenUtils.getStandardCurrencyCode(firstCurrency), KrakenUtils.getStandardCurrencyCode(secondCurrency)));
        }
        return currencyPairs;
    }

    public static OpenOrders adaptOpenOrders(Map<String, KrakenOpenOrder> krakenOrders) {
        LinkedList<LimitOrder> limitOrders = new LinkedList<LimitOrder>();
        for (Map.Entry<String, KrakenOpenOrder> krakenOrder : krakenOrders.entrySet()) {
            String[] descriptionWords = krakenOrder.getValue().getDescription().getOrderDescription().split(" ");
            Order.OrderType type = descriptionWords[0].equals("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
            BigDecimal tradableAmount = krakenOrder.getValue().getVolume().subtract(krakenOrder.getValue().getVolumeExecuted());
            String tradableIdentifier = KrakenUtils.getStandardCurrencyCode(descriptionWords[2].substring(0, 3));
            String transactionCurrency = KrakenUtils.getStandardCurrencyCode(descriptionWords[2].substring(3));
            String id = krakenOrder.getKey();
            Date timestamp = new Date((long)(krakenOrder.getValue().getOpentm() * 1000.0));
            BigMoney limitPrice = BigMoney.of((CurrencyUnit)CurrencyUnit.of((String)transactionCurrency), (BigDecimal)new BigDecimal(descriptionWords[5]));
            LimitOrder order = new LimitOrder(type, tradableAmount, tradableIdentifier, transactionCurrency, id, timestamp, limitPrice);
            limitOrders.add(order);
        }
        return new OpenOrders(limitOrders);
    }
}

