/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.kraken;

import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.Order;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class KrakenUtils {
    public static final List<CurrencyPair> CURRENCY_PAIRS = Arrays.asList(new CurrencyPair("LTC", "XRP"), new CurrencyPair("LTC", "EUR"), new CurrencyPair("LTC", "USD"), new CurrencyPair("NMC", "XRP"), new CurrencyPair("NMC", "EUR"), new CurrencyPair("NMC", "USD"), new CurrencyPair("BTC", "LTC"), new CurrencyPair("BTC", "NMC"), new CurrencyPair("BTC", "XRP"), new CurrencyPair("BTC", "XVN"), new CurrencyPair("BTC", "EUR"), new CurrencyPair("BTC", "USD"), new CurrencyPair("XVN", "XRP"), new CurrencyPair("EUR", "XRP"), new CurrencyPair("EUR", "XVN"), new CurrencyPair("USD", "XRP"), new CurrencyPair("USD", "XRP"), new CurrencyPair("LTC", "KRW"), new CurrencyPair("NMC", "KRW"), new CurrencyPair("BTC", "KRW"), new CurrencyPair("KRW", "XRP"), new CurrencyPair("USD", "XVN"));
    private static Map<String, String> KRAKEN_CURRENCIES_FORWARD = new HashMap<String, String>();
    private static Map<String, String> KRAKEN_CURRENCIES_REVERSE = new HashMap<String, String>();

    private KrakenUtils() {
    }

    public static String getKrakenCurrencyCode(String currencyCode) {
        return KRAKEN_CURRENCIES_FORWARD.get(currencyCode);
    }

    public static String getStandardCurrencyCode(String krakenCurrencyCode) {
        return KRAKEN_CURRENCIES_REVERSE.get(krakenCurrencyCode);
    }

    public static String createKrakenCurrencyPair(String tradableIdentifier, String currency) {
        String currency2;
        String currency1 = KRAKEN_CURRENCIES_FORWARD.get(tradableIdentifier);
        if (currency1 == null) {
            currency1 = tradableIdentifier;
        }
        if ((currency2 = KRAKEN_CURRENCIES_FORWARD.get(currency)) == null) {
            currency2 = currency;
        }
        return currency1 + currency2;
    }

    public static boolean isValidCurrencyPair(CurrencyPair currencyPair) {
        return CURRENCY_PAIRS.contains(currencyPair);
    }

    public static String getKrakenOrderType(Order.OrderType type) {
        return type == Order.OrderType.ASK ? "sell" : "buy";
    }

    public static long getNonce() {
        return System.currentTimeMillis();
    }

    static {
        KRAKEN_CURRENCIES_FORWARD.put("LTC", "XLTC");
        KRAKEN_CURRENCIES_FORWARD.put("NMC", "XNMC");
        KRAKEN_CURRENCIES_FORWARD.put("BTC", "XXBT");
        KRAKEN_CURRENCIES_FORWARD.put("XBT", "XXBT");
        KRAKEN_CURRENCIES_FORWARD.put("VEN", "XXVN");
        KRAKEN_CURRENCIES_FORWARD.put("EUR", "ZEUR");
        KRAKEN_CURRENCIES_FORWARD.put("USD", "ZUSD");
        KRAKEN_CURRENCIES_FORWARD.put("XRP", "XXRP");
        KRAKEN_CURRENCIES_FORWARD.put("KRW", "ZKRW");
        KRAKEN_CURRENCIES_FORWARD.put("XVN", "XXVN");
        KRAKEN_CURRENCIES_REVERSE.put("XLTC", "LTC");
        KRAKEN_CURRENCIES_REVERSE.put("XNMC", "NMC");
        KRAKEN_CURRENCIES_REVERSE.put("XXBT", "BTC");
        KRAKEN_CURRENCIES_REVERSE.put("XXVN", "VEN");
        KRAKEN_CURRENCIES_REVERSE.put("ZEUR", "EUR");
        KRAKEN_CURRENCIES_REVERSE.put("ZUSD", "USD");
        KRAKEN_CURRENCIES_REVERSE.put("XXRP", "XRP");
        KRAKEN_CURRENCIES_REVERSE.put("ZKRW", "KRW");
        KRAKEN_CURRENCIES_REVERSE.put("XXVN", "XVN");
        KRAKEN_CURRENCIES_REVERSE.put("LTC", "LTC");
        KRAKEN_CURRENCIES_REVERSE.put("NMC", "NMC");
        KRAKEN_CURRENCIES_REVERSE.put("XBT", "BTC");
        KRAKEN_CURRENCIES_REVERSE.put("XVN", "VEN");
        KRAKEN_CURRENCIES_REVERSE.put("EUR", "EUR");
        KRAKEN_CURRENCIES_REVERSE.put("USD", "USD");
        KRAKEN_CURRENCIES_REVERSE.put("XRP", "XRP");
        KRAKEN_CURRENCIES_REVERSE.put("KRW", "KRW");
        KRAKEN_CURRENCIES_REVERSE.put("XVN", "XVN");
    }
}

