/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.kraken.service;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.FormParam;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestInvocation;
import si.mazi.rescu.utils.Base64;

public class KrakenDigest
implements ParamsDigest {
    private static final String HMAC_SHA_512 = "HmacSHA512";
    private final Mac mac512;
    private final MessageDigest sha256;

    private KrakenDigest(String secretKeyBase64) throws IllegalArgumentException {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(Base64.decode((byte[])secretKeyBase64.getBytes()), HMAC_SHA_512);
            this.mac512 = Mac.getInstance(HMAC_SHA_512);
            this.mac512.init(secretKey);
            this.sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not decode Base 64 string", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key for hmac initialization.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Illegal algorithm for post body digest. Check the implementation.");
        }
    }

    public static KrakenDigest createInstance(String secretKeyBase64) throws IllegalArgumentException {
        return secretKeyBase64 == null ? null : new KrakenDigest(secretKeyBase64);
    }

    public String digestParams(RestInvocation restInvocation) {
        this.sha256.update(restInvocation.getParamValue(FormParam.class, "nonce").toString().getBytes());
        this.sha256.update(restInvocation.getRequestBody().getBytes());
        this.mac512.update(("/" + restInvocation.getPath()).getBytes());
        this.mac512.update(this.sha256.digest());
        return Base64.encodeBytes((byte[])this.mac512.doFinal()).trim();
    }
}

