/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.kraken.service.polling;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotAvailableFromExchangeException;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.ExchangeInfo;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.kraken.Kraken;
import com.xeiam.xchange.kraken.KrakenAdapters;
import com.xeiam.xchange.kraken.KrakenUtils;
import com.xeiam.xchange.kraken.dto.marketdata.KrakenAssetPairsResult;
import com.xeiam.xchange.kraken.dto.marketdata.KrakenDepth;
import com.xeiam.xchange.kraken.dto.marketdata.KrakenDepthResult;
import com.xeiam.xchange.kraken.dto.marketdata.KrakenTicker;
import com.xeiam.xchange.kraken.dto.marketdata.KrakenTickerResult;
import com.xeiam.xchange.kraken.dto.marketdata.KrakenTrades;
import com.xeiam.xchange.kraken.dto.marketdata.KrakenTradesResult;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import com.xeiam.xchange.utils.Assert;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import si.mazi.rescu.RestProxyFactory;

public class KrakenPollingMarketDataService
extends BasePollingExchangeService
implements PollingMarketDataService {
    private final Kraken kraken;

    public KrakenPollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        Assert.notNull((Object)exchangeSpecification.getSslUri(), (String)"Exchange specification URI cannot be null");
        this.kraken = (Kraken)RestProxyFactory.createProxy(Kraken.class, (String)exchangeSpecification.getSslUri());
    }

    public List<CurrencyPair> getExchangeSymbols() {
        KrakenAssetPairsResult krakenAssetPairs = null;
        try {
            krakenAssetPairs = this.kraken.getAssetPairs();
        }
        catch (IOException e) {
            throw new ExchangeException("Network error fetching exchange symbols!!!");
        }
        if (krakenAssetPairs.getError().length > 0) {
            throw new ExchangeException(krakenAssetPairs.getError().toString());
        }
        return KrakenAdapters.adaptCurrencyPairs(((Map)krakenAssetPairs.getResult()).keySet());
    }

    public Ticker getTicker(String tradableIdentifier, String currency) throws IOException {
        this.verify(tradableIdentifier, currency);
        String krakenCurrencyPair = KrakenUtils.createKrakenCurrencyPair(tradableIdentifier, currency);
        KrakenTickerResult krakenTickerResult = this.kraken.getTicker(krakenCurrencyPair);
        if (krakenTickerResult.getError().length > 0) {
            throw new ExchangeException(Arrays.toString(krakenTickerResult.getError()));
        }
        KrakenTicker krakenTicker = (KrakenTicker)((Map)krakenTickerResult.getResult()).get(krakenCurrencyPair);
        return KrakenAdapters.adaptTicker(krakenTicker, currency, tradableIdentifier);
    }

    public OrderBook getOrderBook(String tradableIdentifier, String currency, Object ... args) throws IOException {
        this.verify(tradableIdentifier, currency);
        String krakenCurrencyPair = KrakenUtils.createKrakenCurrencyPair(tradableIdentifier, currency);
        KrakenDepthResult krakenDepthReturn = null;
        if (args.length > 0) {
            Object arg = args[0];
            if (!(arg instanceof Long) || (Long)arg < 1L) {
                throw new ExchangeException("Orderbook size argument must be an Long with a value greater than 1!");
            }
            krakenDepthReturn = this.kraken.getDepth(krakenCurrencyPair, (Long)arg);
        } else {
            krakenDepthReturn = this.kraken.getDepth(krakenCurrencyPair, null);
        }
        if (krakenDepthReturn.getError().length > 0) {
            throw new ExchangeException(Arrays.toString(krakenDepthReturn.getError()));
        }
        KrakenDepth krakenDepth = (KrakenDepth)((Map)krakenDepthReturn.getResult()).get(krakenCurrencyPair);
        List<LimitOrder> bids = KrakenAdapters.adaptOrders(krakenDepth.getBids(), currency, tradableIdentifier, "bids");
        List<LimitOrder> asks = KrakenAdapters.adaptOrders(krakenDepth.getAsks(), currency, tradableIdentifier, "asks");
        return new OrderBook(null, asks, bids);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Trades getTrades(String tradableIdentifier, String currency, Object ... args) throws IOException {
        this.verify(tradableIdentifier, currency);
        String currencyPair = KrakenUtils.createKrakenCurrencyPair(tradableIdentifier, currency);
        KrakenTradesResult krakenTrades = null;
        if (args.length > 0) {
            Object arg0 = args[0];
            if (!(arg0 instanceof Long)) throw new ExchangeException("args[0] must be of type Long!");
            Long since = (Long)arg0;
            krakenTrades = this.kraken.getTrades(currencyPair, since);
        } else {
            krakenTrades = this.kraken.getTrades(currencyPair);
        }
        if (krakenTrades.getError().length <= 0) return KrakenAdapters.adaptTrades(((KrakenTrades)krakenTrades.getResult()).getTradesPerCurrencyPair(currencyPair), currency, tradableIdentifier, ((KrakenTrades)krakenTrades.getResult()).getLast());
        throw new ExchangeException(krakenTrades.getError().toString());
    }

    public ExchangeInfo getExchangeInfo() throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    private void verify(String tradableIdentifier, String currency) {
        Assert.notNull((Object)tradableIdentifier, (String)"tradableIdentifier cannot be null");
        Assert.notNull((Object)currency, (String)"currency cannot be null");
        Assert.isTrue((boolean)KrakenUtils.isValidCurrencyPair(new CurrencyPair(tradableIdentifier, currency)), (String)("currencyPair is not valid:" + tradableIdentifier + " " + currency));
    }
}

