/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.kraken.service.polling;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotYetImplementedForExchangeException;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.dto.trade.MarketOrder;
import com.xeiam.xchange.dto.trade.OpenOrders;
import com.xeiam.xchange.kraken.KrakenAdapters;
import com.xeiam.xchange.kraken.KrakenAuthenticated;
import com.xeiam.xchange.kraken.KrakenUtils;
import com.xeiam.xchange.kraken.dto.trade.KrakenCancelCount;
import com.xeiam.xchange.kraken.dto.trade.KrakenCancelOrderResult;
import com.xeiam.xchange.kraken.dto.trade.KrakenOpenOrdersResult;
import com.xeiam.xchange.kraken.dto.trade.KrakenOrderResult;
import com.xeiam.xchange.kraken.dto.trade.KrakenOrderReturn;
import com.xeiam.xchange.kraken.dto.trade.KrakenOuterOpen;
import com.xeiam.xchange.kraken.service.KrakenDigest;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingTradeService;
import com.xeiam.xchange.utils.Assert;
import java.io.IOException;
import java.util.Arrays;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;

public class KrakenPollingTradeService
extends BasePollingExchangeService
implements PollingTradeService {
    private KrakenAuthenticated krakenAuthenticated;
    private ParamsDigest signatureCreator;

    public KrakenPollingTradeService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        Assert.notNull((Object)exchangeSpecification.getSslUri(), (String)"Exchange specification URI cannot be null");
        this.krakenAuthenticated = (KrakenAuthenticated)RestProxyFactory.createProxy(KrakenAuthenticated.class, (String)exchangeSpecification.getSslUri());
        this.signatureCreator = KrakenDigest.createInstance(exchangeSpecification.getSecretKey());
    }

    public OpenOrders getOpenOrders() throws IOException {
        KrakenOpenOrdersResult result = this.krakenAuthenticated.listOrders(this.exchangeSpecification.getApiKey(), this.signatureCreator, KrakenUtils.getNonce(), null, null);
        if (!result.isSuccess()) {
            throw new ExchangeException(Arrays.toString(result.getError()));
        }
        return KrakenAdapters.adaptOpenOrders(((KrakenOuterOpen)result.getResult()).getOrders());
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        KrakenOrderResult result = this.krakenAuthenticated.addOrder(this.exchangeSpecification.getApiKey(), this.signatureCreator, KrakenUtils.getNonce(), KrakenUtils.createKrakenCurrencyPair(marketOrder.getTradableIdentifier(), marketOrder.getTransactionCurrency()), KrakenUtils.getKrakenOrderType(marketOrder.getType()), "market", null, marketOrder.getTradableAmount().toString());
        if (!result.isSuccess()) {
            throw new ExchangeException(Arrays.toString(result.getError()));
        }
        return ((KrakenOrderReturn)result.getResult()).getTxid();
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        KrakenOrderResult result = this.krakenAuthenticated.addOrder(this.exchangeSpecification.getApiKey(), this.signatureCreator, KrakenUtils.getNonce(), KrakenUtils.createKrakenCurrencyPair(limitOrder.getTradableIdentifier(), limitOrder.getTransactionCurrency()), KrakenUtils.getKrakenOrderType(limitOrder.getType()), "limit", limitOrder.getLimitPrice().getAmount().toString(), limitOrder.getTradableAmount().toString());
        if (!result.isSuccess()) {
            throw new ExchangeException(Arrays.toString(result.getError()));
        }
        return ((KrakenOrderReturn)result.getResult()).getTxid();
    }

    public boolean cancelOrder(String orderId) throws IOException {
        KrakenCancelOrderResult result = this.krakenAuthenticated.cancelOrder(this.exchangeSpecification.getApiKey(), this.signatureCreator, KrakenUtils.getNonce(), orderId);
        if (!result.isSuccess()) {
            return false;
        }
        return ((KrakenCancelCount)result.getResult()).getCount() > 0;
    }

    public Trades getTradeHistory(Object ... arguments) throws IOException {
        throw new NotYetImplementedForExchangeException();
    }
}

