/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange;

import com.xeiam.xchange.Exchange;
import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.utils.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ExchangeFactory {
    INSTANCE;

    private final Logger log = LoggerFactory.getLogger(ExchangeFactory.class);

    public Exchange createExchange(String exchangeClassName) {
        Assert.notNull(exchangeClassName, "exchangeClassName cannot be null");
        this.log.debug("Creating default exchange from class name");
        try {
            Class<?> exchangeProviderClass = Class.forName(exchangeClassName);
            if (Exchange.class.isAssignableFrom(exchangeProviderClass)) {
                Exchange exchange = (Exchange)exchangeProviderClass.newInstance();
                exchange.applySpecification(exchange.getDefaultExchangeSpecification());
                return exchange;
            }
            throw new ExchangeException("Class '" + exchangeClassName + "' does not implement Exchange");
        }
        catch (ClassNotFoundException e) {
            throw new ExchangeException("Problem creating Exchange (class not found)", e);
        }
        catch (InstantiationException e) {
            throw new ExchangeException("Problem creating Exchange (instantiation)", e);
        }
        catch (IllegalAccessException e) {
            throw new ExchangeException("Problem creating Exchange (illegal access)", e);
        }
    }

    public Exchange createExchange(ExchangeSpecification exchangeSpecification) {
        Assert.notNull(exchangeSpecification, "exchangeSpecfication cannot be null");
        this.log.debug("Creating exchange from specification");
        String exchangeClassName = exchangeSpecification.getExchangeClassName();
        try {
            Class<?> exchangeProviderClass = Class.forName(exchangeClassName);
            if (Exchange.class.isAssignableFrom(exchangeProviderClass)) {
                Exchange exchange = (Exchange)exchangeProviderClass.newInstance();
                exchange.applySpecification(exchangeSpecification);
                return exchange;
            }
            throw new ExchangeException("Class '" + exchangeClassName + "' does not implement Exchange");
        }
        catch (ClassNotFoundException e) {
            throw new ExchangeException("Problem starting exchange provider (class not found)", e);
        }
        catch (InstantiationException e) {
            throw new ExchangeException("Problem starting exchange provider (instantiation)", e);
        }
        catch (IllegalAccessException e) {
            throw new ExchangeException("Problem starting exchange provider (illegal access)", e);
        }
    }
}

